/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhoc.dao.AdhocWorkflowDao;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.tasks.model.Task;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.ValueStoreManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.events.blogpost.BlogPostWorkflowAddedEventImpl;
import com.comalatech.confluence.workflow.events.blogpost.BlogPostWorkflowDeletedEventImpl;
import com.comalatech.confluence.workflow.events.page.PageWorkflowAddedEventImpl;
import com.comalatech.confluence.workflow.events.page.PageWorkflowDeletedEventImpl;
import com.comalatech.confluence.workflow.model.AppliedPageWorkflow;
import com.comalatech.confluence.workflow.parser.WorkflowPreProcessor;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DefaultAdhocWorkflowManager
implements AdhocWorkflowManager,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultAdhocWorkflowManager.class);
    private final String EMPTY_WORKFLOW = "workflows/empty.workflow";
    private ApplicationContext applicationContext;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private InternalWorkflowParameterManager workflowParameterManager;
    private final AdhocWorkflowDao adhocWorkflowDao;
    private WorkflowContainerManager workflowContainerManager;
    private final WorkflowPreProcessor workflowPreProcessor;
    private final ValueStoreManager valueStoreManager;
    private WorkflowAccessor workflowAccessor;
    private StateManager stateManager;
    private final EventPublisher publisher;

    public DefaultAdhocWorkflowManager(WorkflowConfigurationManager workflowConfigurationManager, AdhocWorkflowDao adhocWorkflowDao, WorkflowPreProcessor workflowPreProcessor, ValueStoreManager valueStoreManager, @ComponentImport EventPublisher publisher) {
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.adhocWorkflowDao = adhocWorkflowDao;
        this.workflowPreProcessor = workflowPreProcessor;
        this.valueStoreManager = valueStoreManager;
        this.publisher = publisher;
    }

    public void afterPropertiesSet() throws Exception {
        this.stateManager = (StateManager)this.applicationContext.getBean(StateManager.class);
        this.workflowParameterManager = (InternalWorkflowParameterManager)this.applicationContext.getBean(InternalWorkflowParameterManager.class);
        this.workflowContainerManager = (WorkflowContainerManager)this.applicationContext.getBean(WorkflowContainerManager.class);
        this.workflowAccessor = (WorkflowAccessor)this.applicationContext.getBean(WorkflowAccessor.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public boolean isAdhocWorkflowAllowed(AbstractPage page) {
        if (this.workflowConfigurationManager.getConfiguration() == null) {
            return false;
        }
        return this.workflowConfigurationManager.getConfiguration().isPageApprovalsAllowed(page);
    }

    @Override
    public boolean hasWorkflow(AbstractPage page) {
        try {
            return StringUtils.isNotBlank((CharSequence)this.adhocWorkflowDao.getWorkflowBody(page));
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public Workflow createDefaultTaskAdhocWorkflow() throws WorkflowException {
        String[] defaultStateNames = new String[]{"Tasks"};
        return this.createWorkflow(defaultStateNames, false);
    }

    protected Workflow createWorkflow(String[] stateNames, boolean adhoc) throws WorkflowException {
        Workflow cleanWorkflow = new Workflow();
        cleanWorkflow.setAdhoc(adhoc);
        for (String initialStateName : stateNames) {
            cleanWorkflow.addState(null, this.createAdhocState(initialStateName));
        }
        this.workflowPreProcessor.process(cleanWorkflow);
        return cleanWorkflow;
    }

    @Override
    public Workflow createEmptyWorkflow(String name) throws WorkflowException {
        String rawWorkflow = this.workflowContainerManager.loadSystemWorkflow("workflows/empty.workflow");
        Workflow workflow = this.workflowContainerManager.renderWorkflow(rawWorkflow);
        workflow.setName(name);
        this.workflowPreProcessor.process(workflow);
        return workflow;
    }

    private State createAdhocState(String initialStateName) {
        State state = new State(initialStateName, false);
        state.setAssignable(true);
        state.setTaskable(true);
        return state;
    }

    @Override
    public Workflow savePageWorkflow(AbstractPage page, Workflow workflow, boolean setInitialState) throws WorkflowException {
        if (StringUtils.isNotEmpty((CharSequence)workflow.getErrorMessage())) {
            throw new WorkflowUserException("comalatech.awp.designer.error.markup", workflow.getErrorMessage());
        }
        workflow.validateWorkflow();
        String rawWorkflow = workflow.toMacro().toString();
        this.adhocWorkflowDao.setWorkflowBody(page, rawWorkflow);
        workflow = this.getPageWorkflow(page);
        if (workflow == null) {
            return null;
        }
        if (setInitialState && workflow.getStatesContainer().getInitialState() != null) {
            this.setInitialState(page, workflow);
        }
        workflow.setKey(page.getIdAsString());
        this.workflowParameterManager.registerWorkflowParameters(page.getSpaceKey(), workflow.getWorkflowParameters());
        if (page instanceof Page) {
            this.publisher.publish((Object)new PageWorkflowAddedEventImpl((Page)page, workflow));
        } else if (page instanceof BlogPost) {
            this.publisher.publish((Object)new BlogPostWorkflowAddedEventImpl((BlogPost)page, workflow));
        }
        return workflow;
    }

    @Override
    public void addState(AbstractPage page, String currentStateName, String stateName) throws WorkflowException {
        Workflow workflow = this.getPageWorkflow(page);
        if (workflow == null) {
            return;
        }
        StatesContainer statesContainer = workflow.getStatesContainer();
        if (statesContainer.getState(stateName) != null) {
            return;
        }
        State newState = this.createAdhocState(stateName);
        State currentState = statesContainer.getState(currentStateName);
        try {
            workflow.addState(currentState, newState);
            this.workflowPreProcessor.process(workflow);
            this.savePageWorkflow(page, workflow, false);
        }
        catch (WorkflowException e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void addTask(AbstractPage page, String currentStateName, PageTask task) throws WorkflowException {
        Workflow workflow = this.getPageWorkflow(page);
        if (workflow == null) {
            return;
        }
        State state = workflow.getStatesContainer().getState(currentStateName);
        if (state == null || !state.isTaskable()) {
            return;
        }
        if (state.getTask(task.getName()) != null) {
            log.info("trying to add a task " + task.getName() + " with the same name ");
            return;
        }
        Task workflowTask = new Task(task.getName(), task.getType(), null, null);
        state.addTask(workflowTask);
        try {
            this.workflowPreProcessor.process(workflow);
            this.savePageWorkflow(page, workflow, false);
        }
        catch (WorkflowException e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void removeWorkflow(AbstractPage content) {
        Workflow workflow = null;
        try {
            workflow = this.getPageWorkflow(content);
        }
        catch (WorkflowException e) {
            log.error("Error getting the workflow for content {}", (Object)content);
        }
        this.adhocWorkflowDao.removeWorkflowBody(content);
        if (content instanceof Page) {
            this.publisher.publish((Object)new PageWorkflowDeletedEventImpl((Page)content, workflow));
        } else if (content instanceof BlogPost) {
            this.publisher.publish((Object)new BlogPostWorkflowDeletedEventImpl((BlogPost)content, workflow));
        }
    }

    protected void setInitialState(AbstractPage page, Workflow workflow) {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        this.stateManager.setState(this.valueStoreManager.createValueStore(page), workflow.getStatesContainer().getInitialState(), true, AuthenticatedUserThreadLocal.get(), null, null, pageWorkflows.getReadAck());
    }

    @Override
    public Workflow getPageWorkflow(AbstractPage page) throws WorkflowException {
        return this.getPageWorkflow(page, false);
    }

    @Override
    public Workflow getPageWorkflow(AbstractPage page, boolean addHandle) throws WorkflowException {
        String workflowBody = this.adhocWorkflowDao.getWorkflowBody(page);
        if (StringUtils.isBlank((CharSequence)workflowBody)) {
            return null;
        }
        Workflow workflow = this.workflowContainerManager.renderWorkflow(workflowBody);
        if (addHandle) {
            workflow.setKey(page.getIdAsString());
        }
        return workflow;
    }

    @Override
    public Workflow parseWorkflowMarkup(String workflowMarkup) throws WorkflowException {
        return this.workflowContainerManager.renderWorkflow(workflowMarkup);
    }

    @Override
    public String getWorkflowTemplateBody(String spaceKey, String name) {
        return this.adhocWorkflowDao.getWorkflowTemplateBody(spaceKey, name);
    }

    @Override
    public AppliedPageWorkflow.ConsolidationStatus getConsolidationStatus(String spaceKey, String markup) {
        String value = this.adhocWorkflowDao.getConsolidationStatus(spaceKey, markup);
        return AppliedPageWorkflow.ConsolidationStatus.fromString(value != null ? value : "");
    }

    @Override
    public void setConsolidationStatus(String spaceKey, String markup, AppliedPageWorkflow.ConsolidationStatus status) {
        this.adhocWorkflowDao.setConsolidationStatus(spaceKey, markup, status.toString());
    }

    @Override
    public void removeConsolidationStatus(String spaceKey, String markup) {
        this.adhocWorkflowDao.removeConsolidationStatus(spaceKey, markup);
    }
}

