/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {
    CW.toInit(function () {
        // Load report in an iframe
        var iframe = new CW.iframe({
            id: 'cwreport-iframe',
            url: '/report/space/' + CW.getParam('spaceKey'),
            query: {
                readackColumnSettings: CW.getParam('readAckReportColumnSettings'),
                isSpaceAdmin: CW.isSpaceAdmin(),
                showReadAckReport: CW.getParam('showReadAckReport')
            },
            customData: {
                filterWorkflows: CW.getParam('filterWorkflows'),
                filterStates: CW.getParam('filterStates'),
                filterReadackStatus: CW.getParam('readAckFilterStatus'),
                dateFormat: CW.getParam('cwConfluenceDateFormat'),
                timeFormat: CW.getParam('cwConfluenceTimeFormat'),
                dateTimeFormat: CW.getParam('cwConfluenceDateTimeFormat'),
                locale: CW.getParam('cwConfluenceLocale'),
                timeZone: CW.getParam('cwTimeZone'),
            }
        });
        $('#cw-space-workflows-report').html(iframe.render());
    });
});
