/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};
var requirejs = require || requirejs;
AWP.Blueprints = AWP.Blueprints || {};

AWP.Blueprints = (function() {

    // Obtain space Key from URL param ?key=SPACEKEY, BUT context:space is loaded too in space permissions where there is no key parameter
    var urlParameters = CML.getUrlParameters(),
        spaceKey = urlParameters.key ? urlParameters.key.replace('#','') : undefined;

    requirejs(['cw', 'jquery', 'underscore'], function(CW, $, _) {
        CW.toInit(function () {
            if(CW.getParam('cwSpaceWorkflowAllowed')) { 
                if ($(".plugin-pagetemplates-table").length == 0) {
                    return;
                }
                if(spaceKey) {
                    var url = CW.contextPath + "/rest/adhocworkflows/latest/blueprints/" + spaceKey;
                    $.getJSON(url,
                        function(blueprints) {
                            _.each(blueprints,function(blueprint) {
                                var $template = $("tr[data-template-module-complete-key='" + blueprint.templateKey + "']");
                                var view = new AWP.Blueprints.View.TemplateApp({
                                    el : $template,
                                    blueprint: blueprint
                                });
                            });
                            $(".awp-operation a").tooltip({gravity: "ne"});
                        });
                } else {
                    CW.log("[AWP] No Spacekey found");
                }
        
                // add Manage Workflows button
                var manageWorkflowsBtn = $('<a></a>', {
                        'href': CW.contextPath + '/spaces/viewspaceworkflows.action?key=' + spaceKey
                    })
                    .addClass('aui-button awp-button-manageworkflows')
                    .html(CW.I18n.getText("awp.blueprints.workflow.manageworkflows.button"));
        
                var container = $('<div></div>')
                    .addClass('awp-templates-manageworkflows')
                    .html(manageWorkflowsBtn);
        
                $('.plugin-pagetemplates-table:first').before(container);
            }
        });
    });

    return {
        spaceKey: spaceKey
    }
})();
