/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage.confluence;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.spring.container.ContainerManager;
import java.util.Set;
import org.randombits.storage.BasedStorage;
import org.randombits.storage.StringBasedStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentPropertyStorage
extends StringBasedStorage {
    private static final String CONTENT_PROPERTY_MANAGER = "contentPropertyManager";
    private ContentEntityObject content;
    private ContentPropertyManager contentPropertyManager;

    public ContentPropertyStorage(ContentEntityObject content) {
        this(content, true);
    }

    public ContentPropertyStorage(ContentEntityObject content, boolean useMaps) {
        this(content, useMaps, (ContentPropertyManager)ContainerManager.getComponent((String)CONTENT_PROPERTY_MANAGER));
    }

    public ContentPropertyStorage(ContentEntityObject content, boolean useMaps, ContentPropertyManager manager) {
        super(useMaps ? BasedStorage.BoxType.Real : BasedStorage.BoxType.Virtual);
        if (content == null) {
            throw new IllegalArgumentException("The content may not be null.");
        }
        this.content = content;
        this.contentPropertyManager = manager;
    }

    @Override
    protected Set<String> baseNameSet() {
        return null;
    }

    @Override
    protected String getBaseString(String name) {
        return this.contentPropertyManager.getTextProperty(this.content, name);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    protected void setBaseString(String name, String value) {
        this.contentPropertyManager.setTextProperty(this.content, name, value);
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    public ContentEntityObject getContent() {
        return this.content;
    }
}

