/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.support;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dashboard.actions.DashboardAction;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.AbstractCreateAndEditPageAction;
import com.atlassian.confluence.pages.actions.ViewPageAction;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.pages.templates.actions.AbstractEditPageTemplateAction;
import com.atlassian.confluence.pages.templates.actions.AbstractPageTemplateAction;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.randombits.confluence.support.PageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextAssistant {
    private static final String DECORATOR_PARAM = "decorator";
    private static final String PRINTABLE_DECORATOR = "printable";
    private static final ContextAssistant INSTANCE = new ContextAssistant();
    private PageTemplateManager pageTemplateManager = (PageTemplateManager)ContainerManager.getComponent((String)"pageTemplateManager");

    private ContextAssistant() {
    }

    public static ContextAssistant getInstance() {
        return INSTANCE;
    }

    public PageTemplate getPageTemplate(String templateName, Space space) {
        PageTemplate pt = null;
        if (space != null) {
            pt = this.pageTemplateManager.getPageTemplate(templateName, space);
        }
        if (pt == null) {
            pt = this.pageTemplateManager.getPageTemplate(templateName, null);
        }
        if (pt == null) {
            List pageTemplates = this.pageTemplateManager.getGlobalPageTemplates();
            for (PageTemplate lpt : pageTemplates) {
                if (!lpt.getName().equals(templateName)) continue;
                return lpt;
            }
            return null;
        }
        return pt;
    }

    public List<PageTemplate> getPageTemplates(Space space) {
        List templates = this.pageTemplateManager.getGlobalPageTemplates();
        if (space != null) {
            templates.addAll(this.pageTemplateManager.getPageTemplates(space));
        }
        return templates;
    }

    public boolean isViewAction(PageContext ctx) {
        HttpServletRequest req = ServletActionContext.getRequest();
        if (req == null) {
            return false;
        }
        Action action = ContextAssistant.getCurrentAction();
        ContentEntityObject content = ctx.getEntity();
        return content instanceof AbstractPage && action instanceof ViewPageAction;
    }

    private static Action getCurrentAction() {
        ActionInvocation ai;
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null && (ai = ctx.getActionInvocation()) != null) {
            return ai.getAction();
        }
        return null;
    }

    public boolean isEditAction(PageContext ctx) {
        Action action = ContextAssistant.getCurrentAction();
        ContentEntityObject content = ctx.getEntity();
        if (content instanceof AbstractPage) {
            if (action instanceof AbstractCreateAndEditPageAction) {
                return true;
            }
        } else if (content == null) {
            return this.isCurrentAction(AbstractEditPageTemplateAction.class);
        }
        return false;
    }

    public boolean isDashboardAction(PageContext ctx) {
        return this.isCurrentAction(DashboardAction.class);
    }

    public boolean isTemplateAction(PageContext ctx) {
        return this.isCurrentAction(AbstractPageTemplateAction.class);
    }

    public boolean isCurrentAction(Class<? extends Action> actionClass) {
        Action action = ContextAssistant.getCurrentAction();
        if (action != null) {
            return actionClass.isInstance(action);
        }
        return false;
    }

    public boolean isDefaultDisplay(PageContext ctx) {
        HttpServletRequest req = ServletActionContext.getRequest();
        if (req == null) {
            return false;
        }
        return StringUtils.isBlank((String)req.getParameter(DECORATOR_PARAM)) && "display".equals(ctx.getOutputType());
    }

    public boolean isPrintableDisplay(PageContext ctx) {
        if ("pdf".equals(ctx.getOutputType()) || "word".equals(ctx.getOutputType())) {
            return true;
        }
        HttpServletRequest req = ServletActionContext.getRequest();
        if (req == null) {
            return false;
        }
        return PRINTABLE_DECORATOR.equals(req.getParameter(DECORATOR_PARAM));
    }

    public boolean isPDFDisplay(PageContext ctx) {
        return "pdf".equals(ctx.getOutputType());
    }

    public boolean isWordDisplay(PageContext ctx) {
        return "word".equals(ctx.getOutputType());
    }

    public boolean isPreviewDisplay(PageContext ctx) {
        return "preview".equals(ctx.getOutputType());
    }

    public boolean isRecentlyUpdatedFor(ContentEntityObject ceo, Object user) {
        User realUser = (User)user;
        return ceo.isRecentlyUpdatedFor(realUser);
    }

    public PageTemplate getCurrentPageTemplate(PageContext ctx) {
        if (this.isTemplateAction(ctx)) {
            AbstractPageTemplateAction action = (AbstractPageTemplateAction)ContextAssistant.getCurrentAction();
            return action.getPageTemplate();
        }
        return null;
    }

    public PageContext getPageContext(Object object, PageInfo info) {
        PageContext ctx = object instanceof ContentEntityObject ? new PageContext((ContentEntityObject)object, info.getPageContext()) : new PageContext(null, info.getPageContext());
        return ctx;
    }

    public void setPageTemplateManager(PageTemplateManager pageTemplateManager) {
        this.pageTemplateManager = pageTemplateManager;
    }
}

