/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.validators;

import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ApprovalsReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.model.StateReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.validators.ParameterValidator;

public class ItemsPerPageParameterValidator
implements ParameterValidator {
    private final int minimumSize;
    private final int maximumSize;
    private final String appPluginKey;

    public ItemsPerPageParameterValidator(int minimumSize, int maximumSize, String appPluginKey) {
        this.minimumSize = minimumSize;
        this.maximumSize = maximumSize;
        this.appPluginKey = appPluginKey;
    }

    @Override
    public boolean validate(ReportParameter parameter) throws MacroException {
        if ((StateReportParameters.MAX_ITEMS_PER_PAGE.getKey().equals(parameter.getKey()) || ApprovalsReportParameters.MAX_ITEMS_PER_PAGE.getKey().equals(parameter.getKey())) && parameter.getValue() instanceof StringReportParameterValue) {
            StringReportParameterValue value = (StringReportParameterValue)parameter.getValue();
            try {
                int paramValue = Integer.parseInt((String)value.getValue());
                if (paramValue < this.minimumSize) {
                    throw new MacroException(ComalaI18nBean.getComalaI18nBean().getText(this.appPluginKey + ".document-states-report.error.params.maxItems"));
                }
                if (paramValue > this.maximumSize) {
                    throw new MacroException(ComalaI18nBean.getComalaI18nBean().getText(this.appPluginKey + ".document-states-report.error.params.maxItems.exceeded"));
                }
            }
            catch (NumberFormatException e) {
                throw new MacroException(ComalaI18nBean.getComalaI18nBean().getText(this.appPluginKey + ".document-states-report.error.params.maxItems.invalid"));
            }
        }
        return true;
    }
}

