/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.task;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.comalatech.confluence.documentActivity.upgrade.utils.SupportPackageFile;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.CSVBuilder;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflow.usage.download.commands.PageWorkflowsCSV;
import com.comalatech.confluence.workflow.usage.download.model.PageWorkflowsCSVData;
import com.comalatech.confluence.workflow.usage.model.PageWorkflowReportEntry;
import com.comalatech.confluence.workflow.usage.service.WorkflowsUsageReportService;
import com.comalatech.confluence.workflow.usage.task.model.Status;
import com.comalatech.confluence.workflow.usage.task.model.WorkflowsUsageTask;
import com.comalatech.confluence.workflow.usage.util.WorkflowsUsagePackageFile;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageWorkflowReportTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(PageWorkflowReportTask.class);
    private final SpaceManager spaceManager;
    private final SpaceService spaceService;
    private final WorkflowsUsageReportService workflowsUsageReportService;
    private final ComalaI18nBean comalaI18nBean;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final PageWorkflowsCSV pageWorkflowsCSV;
    private final WorkflowsUsageTask workflowsUsageTask;

    public PageWorkflowReportTask(SpaceManager spaceManager, SpaceService spaceService, WorkflowsUsageReportService workflowsUsageReportService, ComalaI18nBean comalaI18nBean, ReadWriteTransactionService readWriteTransactionService, SupportPresenter templateFileLayoutHelper, WorkflowsUsageTask workflowsUsageTask) {
        this.spaceManager = spaceManager;
        this.spaceService = spaceService;
        this.workflowsUsageReportService = workflowsUsageReportService;
        this.comalaI18nBean = comalaI18nBean;
        this.readWriteTransactionService = readWriteTransactionService;
        this.pageWorkflowsCSV = new PageWorkflowsCSV(templateFileLayoutHelper);
        this.workflowsUsageTask = workflowsUsageTask;
    }

    protected void runInternal() {
        Instant startedAt = Instant.now();
        try {
            WorkflowsUsagePackageFile.deleteFolder(WorkflowsUsagePackageFile.getWorkflowsUsageBasePath("page"));
            if (this.isReportTaskReadyToStart()) {
                CSVBuilder csv = new CSVBuilder();
                this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                    AtomicLong recordsProcessed = new AtomicLong(0L);
                    this.generateHeaders(csv);
                    this.progress.setStatus(Status.IN_PROGRESS.getValue());
                    Collection activeSpaceKeys = this.spaceManager.getAllSpaceKeys(SpaceStatus.CURRENT);
                    for (String spaceKey : activeSpaceKeys) {
                        Space space = this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetch().orElse(null);
                        if (space != null) {
                            try {
                                List<PageWorkflowReportEntry> pageWorkflowReportEntries = this.workflowsUsageReportService.getActivePageWorkflowReportsBySpace(space);
                                if (!pageWorkflowReportEntries.isEmpty()) {
                                    pageWorkflowReportEntries.forEach(usageReport -> {
                                        this.addUsageReport(csv, (PageWorkflowReportEntry)usageReport);
                                        csv.newLine();
                                    });
                                }
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                                throw new RuntimeException(e);
                            }
                        }
                        recordsProcessed.incrementAndGet();
                        this.progress.setPercentage(recordsProcessed.intValue() * 90 / activeSpaceKeys.size());
                    }
                    return null;
                });
                this.pageWorkflowsCSV.generateSupportFile(PageWorkflowsCSVData.builder().csv(csv.get()).build(), SupportPackageFile.generateFolder(WorkflowsUsagePackageFile.getWorkflowsUsageBasePath("page")));
                this.progress.setCompletedSuccessfully(true);
                this.progress.setStatus(Status.SUCCESS.getValue());
                this.workflowsUsageTask.setStatus(Status.SUCCESS);
            } else {
                this.progress.setCompletedSuccessfully(false);
                this.progress.setStatus(Status.FAIL.getValue());
                this.workflowsUsageTask.setStatus(Status.FAIL);
            }
        }
        catch (Exception ex) {
            this.progress.setCompletedSuccessfully(false);
            this.progress.setStatus(Status.FAIL.getValue());
            this.workflowsUsageTask.setStatus(Status.FAIL);
            log.error(ex.getMessage(), (Throwable)ex);
        }
        this.progress.setPercentage(100);
        this.workflowsUsageTask.setDuration(TimerUtils.getDuration(startedAt));
        this.workflowsUsageReportService.savePageWorkflowsUsageReportTask(this.workflowsUsageTask);
    }

    private void generateHeaders(CSVBuilder csv) {
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.pageworkflows.report.csvexport.spacename.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.pageworkflows.report.csvexport.spacekey.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.pageworkflows.report.csvexport.workflowname.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.pageworkflows.report.csvexport.pagetitle.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.pageworkflows.report.csvexport.pageid.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.pageworkflows.report.csvexport.markup.header"));
        csv.newLine();
    }

    private void addUsageReport(CSVBuilder csv, PageWorkflowReportEntry reportEntry) {
        csv.addCell(reportEntry.getPageWorkflowInstance().getSpaceName());
        csv.addCell(reportEntry.getPageWorkflowInstance().getSpaceKey());
        csv.addCell(reportEntry.getPageWorkflowInstance().getWorkflowName());
        csv.addCell(reportEntry.getPageWorkflowInstance().getPageTitle());
        csv.addCell(reportEntry.getPageWorkflowInstance().getPageId().toString());
        csv.addCell(reportEntry.getPageWorkflowInstance().getMarkup());
    }

    private boolean isReportTaskReadyToStart() throws Exception {
        WorkflowsUsageTask storedWorkflowsUsageTask = this.workflowsUsageReportService.getPageWorkflowsUsageReportTask();
        LocalDateTime timeLimit = LocalDateTime.now().plusSeconds(180L);
        while (!Status.IN_PROGRESS.equals((Object)storedWorkflowsUsageTask.getStatus()) && TimerUtils.toEpochMilli(LocalDateTime.now()) <= TimerUtils.toEpochMilli(timeLimit)) {
            storedWorkflowsUsageTask = this.workflowsUsageReportService.getPageWorkflowsUsageReportTask();
            Thread.sleep(2000L);
        }
        this.workflowsUsageTask.setStartedAt(storedWorkflowsUsageTask.getStartedAt());
        return Status.IN_PROGRESS.equals((Object)storedWorkflowsUsageTask.getStatus());
    }

    public String getName() {
        return "Page workflows report task";
    }
}

