/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.rest.validator;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.util.validators.PermissionValidator;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component(value="adminPermissionValidator")
public class AdminPermissionValidator
implements PermissionValidator {
    private final PermissionManager permissionManager;

    public AdminPermissionValidator(@ComponentImport PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public void validate(Collection<Annotation> annotations, Long pageId) throws ApplicationPermissionException {
    }

    @Override
    public void validate(Collection<Annotation> annotations) throws ApplicationPermissionException {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.hasPermission(annotations, user)) {
            throw new ApplicationPermissionException("Forbidden: The user has no admin permission on the application.");
        }
    }

    @Override
    public void validatePages(Collection<Annotation> annotations, List<Long> pageIds) {
    }

    @Override
    public void validateSpaces(Collection<Annotation> annotations, List<String> spaceKeys) {
    }

    private boolean hasPermission(Collection<Annotation> annotations, ConfluenceUser user) throws ApplicationPermissionException {
        PermissionRequired annotation = annotations.stream().filter(a -> a.annotationType().equals(PermissionRequired.class)).findFirst().orElse(null);
        if (annotation != null) {
            for (String permission : annotation.value()) {
                if (this.permissionManager.hasPermission((User)user, Permission.forName((String)permission), PermissionManager.TARGET_APPLICATION)) continue;
                throw new ApplicationPermissionException(user.getName() + " has no " + permission + " permission over " + PermissionManager.TARGET_APPLICATION);
            }
        }
        return this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }
}

