/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.tasks.handler;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.workflow.tasks.handler.AbstractQueuedJobHandler;
import com.comalatech.confluence.workflow.tasks.model.WorkflowLabelledActionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowLabelledActionHandlerImpl
extends AbstractQueuedJobHandler<WorkflowLabelledActionModel> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowLabelledActionHandlerImpl.class);
    private final PageManager pageManager;
    private final LabelManager labelManager;

    public WorkflowLabelledActionHandlerImpl(@ComponentImport PageManager pageManager, @ComponentImport LabelManager labelManager, @ComponentImport UserAccessor userAccessor) {
        this.pageManager = pageManager;
        this.labelManager = labelManager;
        this.userAccessor = userAccessor;
    }

    @Override
    public void handle(WorkflowLabelledActionModel model) {
        if (log.isDebugEnabled()) {
            log.debug("Processing labelled action on page with id: " + model.getPageId());
        }
        try {
            Page page = this.pageManager.getPage(model.getPageId().longValue());
            if (page == null) {
                page = this.pageManager.getBlogPost(model.getPageId().longValue());
            }
            if (page == null) {
                log.error("page " + model.getPageId() + " does not exist");
            } else {
                Label label = LabelParser.parse((String)model.getLabelName()).toLabel();
                label = this.reload(label);
                if (model.getAddLabel().booleanValue()) {
                    this.labelManager.addLabel((Labelable)page, label);
                } else {
                    this.labelManager.removeLabel((Labelable)page, label);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("There was an error processing labelled action on page with id: " + model.getPageId(), e);
        }
    }

    private Label reload(Label label) {
        Label daLabel = this.labelManager.getLabel(label);
        if (daLabel != null) {
            return daLabel;
        }
        return LabelParser.create((Label)label).toLabel();
    }
}

