/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.resources;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhoc.dao.AdhocWorkflowDao;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.parser.WorkflowParser;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.rest.model.RestWorkflow;
import com.comalatech.confluence.workflow.rest.resources.AbstractAdminRestResource;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@WorkflowsAppRequired
@Path(value="/page")
@Produces(value={"application/json"})
public class WorkflowPageResource
extends AbstractAdminRestResource {
    private static final Logger log = LoggerFactory.getLogger(WorkflowPageResource.class);
    private final AdhocWorkflowManager adhocWorkflowManager;
    private final WorkflowParser workflowParser;

    @Inject
    public WorkflowPageResource() {
        this.adhocWorkflowManager = PluginContainerManager.getComponent(AdhocWorkflowManager.class);
        this.workflowParser = PluginContainerManager.getComponent(WorkflowParser.class);
    }

    @Autowired
    public WorkflowPageResource(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @Qualifier(value="workflowTemplateManager") WorkflowTemplateManager workflowTemplateManager, AdhocWorkflowDao adhocWorkflowDao, WorkflowsFeatureManager workflowsFeatureManager, @ComponentImport PageManager pageManager, AdhocWorkflowManager adhocWorkflowManager, WorkflowParser workflowParser) {
        super(permissionManager, spaceManager, workflowTemplateManager, adhocWorkflowDao, workflowsFeatureManager, pageManager);
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.workflowParser = workflowParser;
    }

    @GET
    @Path(value="/{pageId}")
    @PermissionRequired(value={"EDIT"})
    public Response getPageWorkflow(final @PathParam(value="pageId") Long pageId) {
        return new AbstractAdminRestResource.RestPageCommand(pageId){

            @Override
            public Response doExecute() {
                AbstractPage page = WorkflowPageResource.this.pageManager.getAbstractPage(pageId.longValue());
                if (page == null) {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                try {
                    Workflow workflow = WorkflowPageResource.this.adhocWorkflowManager.getPageWorkflow(page, true);
                    WorkflowPageResource.this.moveReadAckMacroOutsideState(workflow);
                    RestWorkflow restWorkflow = WorkflowPageResource.this.buildRestWorkflow(workflow);
                    return Response.ok().entity((Object)restWorkflow).build();
                }
                catch (WorkflowException ex) {
                    log.error("Error getting page workflow", (Throwable)ex);
                    return Response.serverError().build();
                }
            }
        }.execute();
    }

    @PUT
    @Path(value="/{pageId}")
    @PermissionRequired(value={"EDIT"})
    @Consumes(value={"application/json"})
    public Response updateWorkflow(final @PathParam(value="pageId") Long pageId, final Map<String, Object> updateJson) {
        return new AbstractAdminRestResource.RestPageCommand(pageId){

            @Override
            public Response doExecute() {
                AbstractPage page = WorkflowPageResource.this.pageManager.getAbstractPage(pageId.longValue());
                if (page == null) {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                try {
                    String markup = (String)updateJson.get("markup");
                    Workflow workflow = WorkflowPageResource.this.workflowParser.parseWorkflow(markup);
                    Workflow updatedWorkflow = WorkflowPageResource.this.adhocWorkflowManager.savePageWorkflow(page, workflow, false);
                    RestWorkflow restWorkflow = WorkflowPageResource.this.buildRestWorkflow(updatedWorkflow);
                    return Response.ok().entity((Object)restWorkflow).build();
                }
                catch (com.comalatech.workflow.WorkflowException e) {
                    String errorAsJson = WorkflowPageResource.this.convertXHtmlToJson(e.getMessage());
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorAsJson).build();
                }
                catch (ClassCastException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
            }
        }.execute();
    }
}

