/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.comalatech.confluence.adhocworkflows.rest.model.UsersQuerySearchResults;
import com.comalatech.confluence.workflow.rest.expander.AbstractExpanderResponse;
import com.comalatech.confluence.workflow.rest.model.ContentAction;
import com.comalatech.confluence.workflow.rest.model.ContentApproval;
import com.comalatech.confluence.workflow.rest.model.ContentState;
import com.comalatech.confluence.workflow.rest.model.ContentTask;
import com.comalatech.confluence.workflow.rest.model.Message;
import com.comalatech.confluence.workflow.restv2.model.RestState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@XmlRootElement(name="contentWorkflow")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ApiModel(description="Response for all requests to content markup endpoint.")
public class ContentWorkflowInfobannerResponse
extends AbstractExpanderResponse {
    @ApiModelProperty(value="Name of the current workflow", dataType="String", example="Workflow name")
    public String workflowName;
    @XmlElement(type=ContentState.class)
    @ApiModelProperty(value="Information of the current state")
    public ContentState state;
    @ApiModelProperty(value="Information of the most recent published state, if any")
    public ContentState publishedState;
    @ApiModelProperty(value="List of the available approvals in the current state")
    public List<ContentApproval> approvals;
    @ApiModelProperty(value="List existing states in the workflow")
    public List<RestState> states;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ContentAction.ParametersAction.class, name="parameters"), @JsonSubTypes.Type(value=ContentAction.ChangeAction.class, name="change"), @JsonSubTypes.Type(value=ContentAction.ApprovalAction.class, name="approval")})
    @org.codehaus.jackson.annotate.JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @org.codehaus.jackson.annotate.JsonSubTypes(value={@JsonSubTypes.Type(value=ContentAction.ParametersAction.class, name="parameters"), @JsonSubTypes.Type(value=ContentAction.ChangeAction.class, name="change"), @JsonSubTypes.Type(value=ContentAction.ApprovalAction.class, name="approval")})
    @ApiModelProperty(value="List of available actions in the current state")
    public List<ContentAction> actions;
    @ApiModelProperty(value="List of tasks")
    public List<ContentTask> tasks;
    @ApiModelProperty(value="List of messages (error messages or messages set with the message macro)")
    public List<Message> messages;
    @ApiModelProperty(required=true, dataType="boolean", example="true")
    public boolean displayProgressTracker;
    @ApiModelProperty(required=true, dataType="boolean", example="true")
    public boolean displaySuppressReadConfirmation;
    @XmlElement(name="contributors")
    @JsonProperty(value="contributors")
    @org.codehaus.jackson.annotate.JsonProperty(value="contributors")
    @ApiModelProperty
    public UsersQuerySearchResults contributors;
    @ApiModelProperty
    public List<String> roles;

    public ContentApproval findApproval(String name) {
        if (this.approvals == null) {
            return null;
        }
        for (ContentApproval approval : this.approvals) {
            if (!approval.name.equals(name)) continue;
            return approval;
        }
        return null;
    }

    public ContentTask findTask(String name) {
        if (this.tasks == null) {
            return null;
        }
        for (ContentTask task : this.tasks) {
            if (!task.name.equals(name)) continue;
            return task;
        }
        return null;
    }
}

