/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.pageworkflows;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.accesor.PageWorkflowsAccessor;
import com.comalatech.confluence.workflow.accesor.entity.PageWorkflowsRecord;
import com.comalatech.confluence.workflow.model.AppliedPageWorkflow;
import com.comalatech.confluence.workflow.model.PageWorkflowInstance;
import com.comalatech.confluence.workflow.pageworkflows.PageWorkflowsService;
import com.comalatech.confluence.workflow.parser.WorkflowParser;
import com.comalatech.confluence.workflow.usage.mapper.SpacePageWorkflowMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageWorkflowsService
implements PageWorkflowsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultPageWorkflowsService.class);
    private final WorkflowService workflowService;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final PageWorkflowsAccessor pageWorkflowsAccessor;
    private final WorkflowParser workflowParser;
    private final SpacePageWorkflowMapper spacePageWorkflowMapper;
    private final PageManager pageManager;
    private final SpaceService spaceService;
    private final AdhocWorkflowManager adhocWorkflowManager;
    public static final String IS_PAGE_READ_CONFIRMATION_WORKFLOW = "isPageReadConfirmation";

    public DefaultPageWorkflowsService(WorkflowService workflowService, WorkflowsFeatureManager workflowsFeatureManager, PageWorkflowsAccessor pageWorkflowsAccessor, WorkflowParser workflowParser, PageManager pageManager, SpaceService spaceService, AdhocWorkflowManager adhocWorkflowManager) {
        this.workflowService = workflowService;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.pageWorkflowsAccessor = pageWorkflowsAccessor;
        this.workflowParser = workflowParser;
        this.pageManager = pageManager;
        this.spaceService = spaceService;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.spacePageWorkflowMapper = new SpacePageWorkflowMapper();
    }

    @Override
    public List<PageWorkflowInstance> getPageWorkflowsBySpace(Space space) throws WorkflowException {
        ArrayList<PageWorkflowInstance> result = new ArrayList<PageWorkflowInstance>();
        List<String> keys = this.workflowsFeatureManager.getPageWorkflowPropertyKeys();
        List<PageWorkflowsRecord> pageWorkflows = this.pageWorkflowsAccessor.getPageWorkflowsInSpace(space.getId(), keys);
        if (!pageWorkflows.isEmpty()) {
            List<com.comalatech.workflow.model.Workflow> spaceWorkflows = this.workflowService.getWorkflows(space.getKey());
            List activeSpaceWorkflows = spaceWorkflows.stream().filter(com.comalatech.workflow.model.Workflow::isActive).filter(workflow -> workflow.getLabelNames().isEmpty()).collect(Collectors.toList());
            List activeSpaceWorkflowsWithLabels = spaceWorkflows.stream().filter(com.comalatech.workflow.model.Workflow::isActive).filter(wf -> !wf.getLabelNames().isEmpty()).collect(Collectors.toList());
            for (PageWorkflowsRecord record : pageWorkflows) {
                Workflow workflow2;
                String markup = record.getWorkflow();
                if (markup == null || markup.isEmpty()) continue;
                AbstractPage content = this.pageManager.getAbstractPage(record.getContentId().longValue());
                if (content == null || content.isDeleted()) {
                    log.warn("Page {} does not exist or is in trash", (Object)record.getContentId());
                    continue;
                }
                try {
                    workflow2 = this.workflowParser.parseWorkflow(markup);
                }
                catch (Exception ex) {
                    log.warn("Failed to parse workflow {} for page id {}", new Object[]{markup, content.getIdAsString(), ex});
                    continue;
                }
                PageWorkflowInstance pageWorkflow = this.spacePageWorkflowMapper.map(space, record);
                pageWorkflow.setWorkflowName(workflow2.getName());
                pageWorkflow.setPageTaskWorkflow(workflow2.isPageTask());
                if (!activeSpaceWorkflows.isEmpty()) {
                    pageWorkflow.setActive(false);
                } else if (!activeSpaceWorkflowsWithLabels.isEmpty()) {
                    List contentLabels = Optional.of(content).map(AbstractLabelableEntityObject::getLabels).orElse(Collections.emptyList()).stream().map(Label::toString).collect(Collectors.toList());
                    boolean isActive = true;
                    for (com.comalatech.workflow.model.Workflow activeSpaceWorkflowWithLabel : activeSpaceWorkflowsWithLabels) {
                        List<String> spaceWorkflowLabels = activeSpaceWorkflowWithLabel.getLabelNames();
                        boolean hasMatchingLabel = contentLabels.stream().anyMatch(spaceWorkflowLabels::contains);
                        if ((!hasMatchingLabel || activeSpaceWorkflowWithLabel.isInvertLabels()) && (hasMatchingLabel || !activeSpaceWorkflowWithLabel.isInvertLabels())) continue;
                        isActive = false;
                        break;
                    }
                    pageWorkflow.setActive(isActive);
                } else {
                    pageWorkflow.setActive(true);
                }
                result.add(pageWorkflow);
            }
        }
        return result;
    }

    @Override
    public List<AppliedPageWorkflow> getPageWorkflowsToConsolidate(String spaceKey) throws WorkflowException {
        Space space = this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetch().orElse(null);
        if (space == null) {
            log.debug("Empty page workflows list as no space found for key: {}", (Object)spaceKey);
            return Collections.emptyList();
        }
        List<PageWorkflowInstance> records = this.getPageWorkflowsBySpace(space);
        ArrayList<AppliedPageWorkflow> pageWorkflows = new ArrayList<AppliedPageWorkflow>();
        if (records.isEmpty()) {
            log.debug("Empty page workflows list as no page workflows found for key: {}", (Object)spaceKey);
            return pageWorkflows;
        }
        records.stream().filter(PageWorkflowInstance::isActive).filter(this::isCurrentContent).filter(this::hasValidWorkflow).collect(Collectors.groupingBy(PageWorkflowInstance::getMarkup)).forEach((markup, contents) -> {
            String workflowName = ((PageWorkflowInstance)contents.get(0)).getWorkflowName();
            AppliedPageWorkflow.ConsolidationStatus status = this.adhocWorkflowManager.getConsolidationStatus(spaceKey, (String)markup);
            pageWorkflows.add(this.create(workflowName, (String)markup, (List<PageWorkflowInstance>)contents, status));
        });
        return pageWorkflows.stream().sorted(Comparator.comparing(AppliedPageWorkflow::getWorkflowName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
    }

    private boolean isCurrentContent(PageWorkflowInstance pageWorkflowInstance) {
        AbstractPage content = this.pageManager.getAbstractPage(pageWorkflowInstance.getPageId().longValue());
        if (content == null) {
            return false;
        }
        return content.isLatestVersion() && !content.isDeleted() && !content.isDraft();
    }

    private boolean hasValidWorkflow(PageWorkflowInstance pageWorkflowInstance) {
        return !pageWorkflowInstance.getMarkup().contains(IS_PAGE_READ_CONFIRMATION_WORKFLOW) && !pageWorkflowInstance.isPageTaskWorkflow();
    }

    private AppliedPageWorkflow create(String workflowName, String markup, List<PageWorkflowInstance> pageWorkflowInstances, AppliedPageWorkflow.ConsolidationStatus status) {
        return new AppliedPageWorkflow(workflowName, markup, this.convertFrom(pageWorkflowInstances), status);
    }

    private AppliedPageWorkflow.Content convertFrom(PageWorkflowInstance pageWorkflowInstance) {
        return new AppliedPageWorkflow.Content(pageWorkflowInstance.getPageId(), pageWorkflowInstance.getPageTitle());
    }

    private List<AppliedPageWorkflow.Content> convertFrom(List<PageWorkflowInstance> pageWorkflowInstances) {
        return pageWorkflowInstances.stream().map(this::convertFrom).collect(Collectors.toList());
    }
}

