/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.macros.AbstractConditionalMacro;
import com.comalatech.confluence.workflow.macros.DescriptionMacro;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import com.comalatech.workflow.model.TasksMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WorkflowParameters
extends MacroParameters {
    private static final String PARAM_WORKFLOW_NAME = "name";
    public static final String[] PARAM_WORKFLOW_LABEL = new String[]{"label", "labels"};
    public static final String PARAM_WORKFLOW_LABEL_INVERT = "invertlabel";
    private static final String[] PARAM_WORKFLOW_SPACE = new String[]{"space", "spaces"};
    private static final String PARAM_WORKFLOW_CSS = "css";
    private static final String PARAM_WORKFLOW_STICKY_LABELS = "stickylabels";
    private static final String PARAM_WORKFLOW_ADMINS = "adminusers";
    private static final String PARAM_WORKFLOW_INITMACRO = "initmacro";
    private static final String[] PARAM_HEADER = new String[]{"header", "headertemplate"};
    private static final String[] PARAM_FOOTER = new String[]{"footer", "footertemplate"};
    private static final String PARAM_WORKFLOW_HIDESTATUS = "hidestatus";
    public static final String PARAM_DISPLAY_PROGRESS_TRACKER = "progresstracker";
    private static final String PARAM_CONTENTTYPE = "content";
    private static final String PARAM_DISABLED = "disabled";
    private static final String PARAM_ADHOC = "adhoc";
    private static final String[] PARAM_HIDESTATES = new String[]{"hidestates", "hideStates"};
    private static final String[] PARAM_KEY = new String[]{"key"};
    private static final String[] PARAM_TIP = new String[]{"tip"};
    private static final String[] PARAM_TASKMODE = new String[]{"strict", "stricttasks"};
    private static final String[] PARAM_BLUEPRINTKEY = new String[]{"blueprint", "blueprintkey", "blueprintKey"};
    private static final String[] PARAM_UPDATESTATUS = new String[]{"updatestatus", "updateStatus"};
    public static final String[] PARAM_PAGE_READ_CONFIRMATION = new String[]{"isPageReadConfirmation"};
    private List<Label> labels = new ArrayList<Label>();
    private boolean invertLabels;
    private String[] spaces;
    private String pageHeaderTemplate;
    private String pageFooterTemplate;
    private int hidestatus;
    private String name;
    private String description;
    private String adminUsers;
    private String initMacro;
    private String stickyLabels;
    private String workflowCss;
    private String key;
    private String blueprintKey;
    private String tip;
    private boolean updateStatus;
    private boolean pageWorkflows;
    private boolean blogPostWorkflow;
    private boolean active;
    private boolean adhoc;
    private boolean hideStates;
    private boolean displayProgressTracker;
    private boolean pageReadConfirmation;
    private TasksMode tasksMode;
    private AbstractPage page;

    public WorkflowParameters(Map parameters, RenderContext renderContext, SpaceManager spaceManager) throws MacroException {
        super(parameters, renderContext);
        String[] includes;
        String includeLabelsString = this.get(PARAM_WORKFLOW_LABEL);
        for (String include : includes = MiscUtils.splitAndTrim(includeLabelsString)) {
            this.labels.add(AbstractConditionalMacro.parseLabel(include));
        }
        this.invertLabels = this.getFlagWithDefault(PARAM_WORKFLOW_LABEL_INVERT, false);
        String spacesList = this.get(PARAM_WORKFLOW_SPACE, this.getAbstractPage().getLatestVersion().getSpaceKey());
        this.spaces = MiscUtils.splitAndTrim(spacesList);
        this.checkSpaces(spaceManager, this.spaces);
        this.pageHeaderTemplate = this.get(PARAM_HEADER);
        this.pageFooterTemplate = this.get(PARAM_FOOTER);
        String contentType = this.get(PARAM_CONTENTTYPE, "pages,news").toLowerCase();
        this.pageWorkflows = contentType.contains("page") || contentType.contains("pages");
        this.blogPostWorkflow = contentType.contains("news") || contentType.contains("blog");
        this.hidestatus = this.handleHideStatusParam(this.get(PARAM_WORKFLOW_HIDESTATUS));
        this.name = this.get(PARAM_WORKFLOW_NAME);
        this.adminUsers = this.get(PARAM_WORKFLOW_ADMINS);
        this.initMacro = this.get(PARAM_WORKFLOW_INITMACRO);
        this.stickyLabels = this.get(PARAM_WORKFLOW_STICKY_LABELS);
        this.workflowCss = this.get(PARAM_WORKFLOW_CSS);
        this.active = !this.getFlag(PARAM_DISABLED);
        this.active = !this.getFlag(PARAM_DISABLED);
        this.key = this.get(PARAM_KEY);
        this.blueprintKey = this.get(PARAM_BLUEPRINTKEY);
        this.updateStatus = this.getFlagWithDefault(PARAM_UPDATESTATUS, false);
        this.adhoc = this.getFlagWithDefault(PARAM_ADHOC, false);
        this.hideStates = this.getFlagWithDefault(PARAM_HIDESTATES, false);
        this.displayProgressTracker = this.getFlagWithDefault(PARAM_DISPLAY_PROGRESS_TRACKER, true);
        try {
            this.tasksMode = this.getFlag(PARAM_TASKMODE, true) ? TasksMode.STRICT : TasksMode.LENIENT;
        }
        catch (MacroException e) {
            this.tasksMode = TasksMode.DEFAULT;
        }
        this.tip = this.get(PARAM_TIP);
        if (StringUtils.isNotBlank((CharSequence)this.tip)) {
            this.tip = this.tip.replaceAll("!", "|");
        }
        this.description = DescriptionMacro.getDescription(renderContext);
        this.pageReadConfirmation = this.getFlagWithDefault(PARAM_PAGE_READ_CONFIRMATION, false);
        Arrays.sort(this.spaces);
    }

    public WorkflowParameters(String name, AbstractPage page, Label label, String spaces, boolean pageWorkflows, boolean blogPostWorkflow) throws MacroException {
        super(null, null);
        this.labels.add(label);
        this.spaces = MiscUtils.splitAndTrim(spaces);
        Arrays.sort(this.spaces);
        this.pageWorkflows = pageWorkflows;
        this.blogPostWorkflow = blogPostWorkflow;
        this.page = page;
        this.name = name;
        this.active = true;
    }

    private int handleHideStatusParam(String paramValue) {
        int hidestatus = 0;
        if (paramValue != null && paramValue.toLowerCase().matches("true|false|readonly")) {
            hidestatus = paramValue.equalsIgnoreCase("true") ? 1 : (paramValue.equalsIgnoreCase("false") ? 0 : 2);
        }
        return hidestatus;
    }

    private void checkSpaces(SpaceManager spaceManager, String[] keys) throws MacroException {
        for (String key : keys) {
            if (spaceManager.getSpace(key) != null) continue;
            throw new MacroException("Invalid space key " + key);
        }
    }

    public String[] getSpaces() {
        return this.spaces;
    }

    public String getPageHeaderTemplate() {
        return this.pageHeaderTemplate;
    }

    public String getPageFooterTemplate() {
        return this.pageFooterTemplate;
    }

    public boolean isBlogPostWorkflow() {
        return this.blogPostWorkflow;
    }

    public boolean isPageWorkflows() {
        return this.pageWorkflows;
    }

    public int getHidestatus() {
        return this.hidestatus;
    }

    public String getName() {
        return this.name;
    }

    public String getAdminUsers() {
        return this.adminUsers;
    }

    public String getInitMacro() {
        return this.initMacro;
    }

    public String getStickyLabels() {
        return this.stickyLabels;
    }

    public String getWorkflowCss() {
        return this.workflowCss;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAdhoc() {
        return this.adhoc;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public AbstractPage getAbstractPage() throws MacroException {
        if (this.page == null) {
            return super.getAbstractPage();
        }
        return this.page;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isHideStates() {
        return this.hideStates;
    }

    public String getKey() {
        return this.key;
    }

    public String getTip() {
        return this.tip;
    }

    public TasksMode getTasksMode() {
        return this.tasksMode;
    }

    public boolean isDisplayProgressTracker() {
        return this.displayProgressTracker;
    }

    public String getBlueprintKey() {
        return this.blueprintKey;
    }

    public boolean isUpdateStatus() {
        return this.updateStatus;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public boolean isInvertLabels() {
        return this.invertLabels;
    }

    public boolean isPageReadConfirmation() {
        return this.pageReadConfirmation;
    }
}

