/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.macros.AbstractWorkflowElementMacro;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import com.comalatech.confluence.workflow.model.WorkflowParameter;
import com.comalatech.workflow.model.WorkflowParameterType;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WorkflowParameterMacro
extends AbstractWorkflowElementMacro {
    @Override
    public boolean allowsAnonymousUser() {
        return false;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        this.getElementsList(renderContext).add(new Parameters(parameters, body, renderContext).getWorkflowParameter());
        return "";
    }

    public class Parameters
    extends MacroParameters {
        private final WorkflowParameter workflowParameter;

        public Parameters(Map parameters, String body, RenderContext renderContext) throws MacroException {
            super(parameters, renderContext);
            String name = this.get(new String[]{"name", "0", "parameter"}, true);
            String description = this.get(new String[]{"description"});
            String options = this.get("options");
            String typeName = this.get(new String[]{"type"});
            if (typeName != null) {
                typeName = typeName.toLowerCase();
            } else if (StringUtils.isNotBlank((CharSequence)options)) {
                typeName = WorkflowParameterType.LIST.getName();
            }
            WorkflowParameterType type = WorkflowParameterType.parse(typeName);
            this.workflowParameter = new WorkflowParameter(name, description, type, body.trim(), options, this.getFlag(new String[]{"editable", "edit"}, false));
        }

        public WorkflowParameter getWorkflowParameter() {
            return this.workflowParameter;
        }
    }
}

