/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.manager;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.manager.PdfManager;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.model.PdfExportActionModel;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.model.PdfExportResultModel;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.service.PdfExporterService;
import com.comalatech.confluence.workflow.WorkflowException;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultPdfManager
implements PdfManager {
    public static final String K15T_RETURN_NULL_MESSAGE_KEY = "com.comalatech.macro.k15t.error.pdf-export-api-return-null";
    public static final String K15T_ERROR_FILE_ATTACHED_MESSAGE_KEY = "com.comalatech.macro.k15t.error.pdf-export-api-attached-error";
    public static final String K15T_PDF_EXPORT_PAGE_NOT_FOUND_MSG_KEY = "com.comalatech.macro.k15t.error.pdf-export-page-not-found";
    private final PdfExporterService pdfExporterService;
    private final AttachmentManager attachmentManager;
    private final GlobalSettingsManager globalSettingsManager;
    private final ComalaI18nBean comalaI18nBean;

    public DefaultPdfManager(PdfExporterService pdfExporterService, @ComponentImport AttachmentManager attachmentManager, @ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, ComalaI18nBean comalaI18nBean) {
        this.pdfExporterService = pdfExporterService;
        this.attachmentManager = attachmentManager;
        this.globalSettingsManager = globalSettingsManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public Attachment attachCurrentVersionPDF(AbstractPage abstractPage) throws IOException, WorkflowException {
        if (abstractPage == null) {
            throw new WorkflowException(this.comalaI18nBean.getText(K15T_PDF_EXPORT_PAGE_NOT_FOUND_MSG_KEY));
        }
        return this.savePdfAsAttachment(abstractPage, this.pdfExporterService.generatePdfOfAbstractPage(abstractPage));
    }

    @Override
    public Attachment attachCurrentVersionPDF(AbstractPage abstractPage, PdfExportActionModel model) throws IOException, WorkflowException {
        if (abstractPage == null) {
            throw new WorkflowException(this.comalaI18nBean.getText(K15T_PDF_EXPORT_PAGE_NOT_FOUND_MSG_KEY));
        }
        return this.savePdfAsAttachment(abstractPage, this.pdfExporterService.generatePdfOfAbstractPage(abstractPage, model));
    }

    private Attachment savePdfAsAttachment(AbstractPage abstractPage, PdfExportResultModel pdfContent) throws IOException, WorkflowException {
        if (pdfContent == null) {
            throw new WorkflowException(this.comalaI18nBean.getText(K15T_RETURN_NULL_MESSAGE_KEY));
        }
        Attachment attachment = this.attachmentManager.getAttachment((ContentEntityObject)abstractPage, pdfContent.getFilename());
        Attachment previousVersion = null;
        if (attachment == null) {
            attachment = new Attachment();
        } else {
            previousVersion = attachment.copy();
        }
        attachment.setFileName(pdfContent.getFilename());
        attachment.setContainer((ContentEntityObject)abstractPage);
        attachment.setFileSize((long)pdfContent.getFileSize().intValue());
        attachment.setMediaType("application/pdf");
        this.attachmentManager.saveAttachment(attachment, previousVersion, pdfContent.getContent());
        if (!pdfContent.isSuccessful()) {
            throw new WorkflowException(this.comalaI18nBean.getText(K15T_ERROR_FILE_ATTACHED_MESSAGE_KEY, new String[]{this.globalSettingsManager.getGlobalSettings().getBaseUrl(), attachment.getDownloadPath()}));
        }
        return attachment;
    }
}

