/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.repository;

import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.usecases.repository.MetadataRepository;
import com.comalatech.confluence.cloud.migration.usecases.repository.entity.MetadataRecord;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Component;

@Component
public class MetadataRepositoryImpl
implements MetadataRepository {
    private final EntityManagerProvider entityManagerProvider;
    private static final String METADATA_KEY = "metadata.%";

    public MetadataRepositoryImpl(@ComponentImport EntityManagerProvider entityManagerProvider) {
        this.entityManagerProvider = entityManagerProvider;
    }

    @Override
    public List<MetadataRecord> findAllMetadataBySpace(Space space) {
        ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>();
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select propertySet.entityId as entityId, propertySet.key as entityKey, propertySet.stringVal as value, content.space.id as spaceId from BucketPropertySetItem propertySet inner join ContentEntityObject content on propertySet.entityId = content.id where content.originalVersion is null and content.contentStatus = 'current' and content.space.id = :space_id and propertySet.key not like 'metadata.awpState' and propertySet.key like :metadata_key order by entityId desc", Tuple.class);
        query.setParameter("metadata_key", (Object)METADATA_KEY);
        query.setParameter("space_id", (Object)space.getId());
        List metadataItems = query.getResultList();
        if (metadataItems != null && !metadataItems.isEmpty()) {
            metadataItems.forEach(row -> records.add(new MetadataRecord((Long)row.get(0), (String)row.get(1), (String)row.get(2))));
        }
        return records;
    }
}

