/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};

AWP.Blueprints = AWP.Blueprints || {};
AWP.Blueprints.View = AWP.Blueprints.View || {};

var requirejs = require || requirejs;
requirejs(['backbone', 'jquery'], function (Backbone, $) {
    // Blueprints get attached to existing template tr
    AWP.Blueprints.View.TemplateApp = Backbone.View.extend({
        idMessage: 'awp-blueprint-msg',

        events: {
            "click a.awp-attach-workflow" : "attachWorkflow",
            "click a.awp-detach-workflow" : "detachWorkflow"
        },

        attachWorkflow: function() {
            var dialog = new AWP.Blueprints.View.AttachWorkflow({
                template: this,
                idMessage: this.idMessage
            });
            dialog.render();
            $('#'+this.idMessage)
                .html('')
                .hide();
        },

        detachWorkflow: function() {
            var dialog = new AWP.Blueprints.View.DetachWorkflow({
                template: this,
                idMessage: this.idMessage
            });
            dialog.render();
            $('#'+this.idMessage)
                .html('')
                .hide();
        },

        initialize: function() {
            this.blueprint = this.options.blueprint;
            this.$operations = this.$(".template-operations");
            this.render();
        },

        render: function() {
            this.$(".awp-operation").remove();
            var blueprint = this.blueprint;

            if (blueprint.workflowName) {
                this.$operations.append(AWP.Blueprints.Templates.detachWorkflowAction({workflowName: blueprint.workflowName}));
            } else {
                this.$operations.append(AWP.Blueprints.Templates.attachWorkflowAction());
            }
            this.$(".awp-operation").tooltip({gravity: "ne"});

        }
    });
});
