/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.randombits.storage.BasedStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectBasedStorage
extends BasedStorage {
    private static final Logger LOG = Logger.getLogger(ObjectBasedStorage.class);

    public ObjectBasedStorage(BasedStorage.BoxType boxType) {
        super(boxType);
    }

    protected <T> T getBaseObject(String name, Class<T> clazz) {
        Object value = this.getBaseObject(name);
        return this.toType(value, null, clazz);
    }

    @Override
    protected Boolean getBaseBoolean(String name) {
        return this.getBaseObject(name, Boolean.class);
    }

    @Override
    protected Date getBaseDate(String name) {
        return this.getBaseObject(name, Date.class);
    }

    @Override
    protected Double getBaseDouble(String name) {
        Number theNumber;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Value for " + name + ": " + this.getBaseNumber(name)));
        }
        return null == (theNumber = this.getBaseNumber(name)) ? null : new Double(theNumber.doubleValue());
    }

    @Override
    protected Integer getBaseInteger(String name) {
        Number theNumber;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Value for " + name + ": " + this.getBaseNumber(name)));
        }
        return null == (theNumber = this.getBaseNumber(name)) ? null : new Integer(theNumber.intValue());
    }

    @Override
    protected Long getBaseLong(String name) {
        Number theNumber;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Value for " + name + ": " + this.getBaseNumber(name)));
        }
        return null == (theNumber = this.getBaseNumber(name)) ? null : new Long(theNumber.longValue());
    }

    @Override
    protected Number getBaseNumber(String name) {
        return this.getBaseObject(name, Number.class);
    }

    @Override
    protected List<?> getBaseObjectList(String name) {
        return this.getBaseObject(name, List.class);
    }

    @Override
    protected String getBaseString(String name) {
        return this.getBaseObject(name, String.class);
    }

    @Override
    protected String[] getBaseStringArray(String name) {
        return (String[])this.getBaseObject(name);
    }

    @Override
    protected void setBaseBoolean(String name, Boolean value) {
        this.setBaseObject(name, value);
    }

    @Override
    protected void setBaseDate(String name, Date value) {
        this.setBaseObject(name, value);
    }

    @Override
    protected void setBaseDouble(String name, Double value) {
        this.setBaseObject(name, value);
    }

    @Override
    protected void setBaseInteger(String name, Integer value) {
        this.setBaseObject(name, value);
    }

    @Override
    protected void setBaseLong(String name, Long value) {
        this.setBaseObject(name, value);
    }

    @Override
    protected void setBaseObjectList(String name, List<?> value) {
        this.setBaseObject(name, value);
    }

    @Override
    protected void setBaseString(String name, String value) {
        this.setBaseObject(name, value);
    }

    @Override
    protected void setBaseStringArray(String name, String[] value) {
        this.setBaseObject(name, value);
    }
}

