/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.general;

import java.math.BigDecimal;
import org.randombits.confluence.filtering.criteria.general.GeneralCriterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberCriterion
extends GeneralCriterion<Number> {
    private Number minValue;
    private Number maxValue;
    private Boolean decimal;
    private Number value;

    public NumberCriterion() {
        this(null, null, null);
    }

    public NumberCriterion(Boolean isDecimal) {
        this(null, null, isDecimal);
    }

    public NumberCriterion(Number minValue, Number maxValue) {
        this(minValue, maxValue, null);
    }

    public NumberCriterion(Number minValue, Number maxValue, Boolean isDecimal) {
        super(Number.class);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.decimal = isDecimal;
    }

    @Override
    public boolean matchesType(Number number) {
        if (this.minValue != null && (number == null || this.minValue.doubleValue() > number.doubleValue())) {
            return false;
        }
        if (this.maxValue != null && (number == null || this.maxValue.doubleValue() < number.doubleValue())) {
            return false;
        }
        if (this.value != null && (number == null || this.value.doubleValue() != number.doubleValue())) {
            return false;
        }
        return this.decimal == null || this.decimal.booleanValue() == this.isDecimalInstance(number);
    }

    private boolean isDecimalInstance(Number number) {
        return number instanceof Float || number instanceof Double || number instanceof BigDecimal;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Number minValue) {
        this.minValue = minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Number maxValue) {
        this.maxValue = maxValue;
    }

    public void setDecimal(Boolean isDecimal) {
        this.decimal = isDecimal;
    }

    public Boolean isDecimal() {
        return this.decimal;
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    public String toString() {
        return "{number" + (this.minValue != null ? "; min: " + this.minValue : "") + (this.maxValue != null ? "; max: " + this.maxValue : "") + (this.decimal != null ? "; is decimal: " + this.decimal : "") + "}";
    }
}

