/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.content;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.spring.container.ContainerManager;
import org.randombits.confluence.filtering.criteria.CriteriaException;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.filtering.criteria.content.AbstractSpaceCriterion;

public class SpaceThemeCriterion
extends AbstractSpaceCriterion {
    private ThemeManager themeManager;
    private String themeKey;

    public SpaceThemeCriterion(String themeKey) {
        this.themeKey = themeKey;
    }

    protected boolean matchesSpace(Space space) {
        String spaceThemeKey = this.themeManager.getSpaceThemeKey(space.getKey());
        return this.themeKey.equals(spaceThemeKey);
    }

    protected boolean matchesNullSpace() {
        String globalThemeKey = this.themeManager.getGlobalThemeKey();
        return this.themeKey.equals(globalThemeKey);
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public String getThemeKey() {
        return this.themeKey;
    }

    public String toString() {
        return "{space theme: " + this.themeKey + "}";
    }

    public static class Interpreter
    implements CriterionInterpreter {
        public static final String GLOBAL_THEME = "@global";

        public Criterion createCriterion(String value) throws CriteriaException {
            if (GLOBAL_THEME.equals(value)) {
                ThemeManager themeManager = (ThemeManager)ContainerManager.getComponent((String)"themeManager");
                value = themeManager.getGlobalThemeKey();
            }
            return new SpaceThemeCriterion(value);
        }
    }
}

