/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.workflow.model;

import com.comalatech.workflow.model.WorkflowParameterType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

@XmlRootElement(name="input")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ApiModel(description="<p>Information related to an input field to get parameter info.</p><p>See the <a href=\"https://apps.appf.re/cdmdc/doc/workflowparametermacro/UzWWHo\">workflow parameter macro</a> for further information.</p>")
public class InputField {
    @ApiModelProperty(value="Unique identificator of the input field", dataType="string")
    private String id;
    @ApiModelProperty(value="Name of the related parameter", dataType="string", example="Reviewers")
    private String name;
    @ApiModelProperty(value="Value for the parameter", dataType="string", example="confluence-users")
    private String value;
    @ApiModelProperty(value="Input type from the supported ones", example="group")
    private InputType type;
    @ApiModelProperty(value="In case of LIST type, the valid options to show")
    private List<String> options;
    @ApiModelProperty(value="Description of the related parameter", dataType="string", example="Reviewers group")
    private String description;

    public InputField() {
    }

    public InputField(String id, String name, String value, InputType type) {
        this(id, name, null, value, type, null);
    }

    public InputField(String id, String name, String value, List<String> options) {
        this(id, name, null, value, InputType.LIST, options);
    }

    public InputField(String id, String name, String description, String value, InputType type, List<String> options) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.value = value;
        this.type = type;
        this.options = options;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public InputType getType() {
        return this.type;
    }

    public List<String> getOptions() {
        return this.options;
    }

    @ApiModel(description="Different supported input field's types")
    public static enum InputType {
        TEXT,
        USER,
        USERORGROUP,
        GROUP,
        DURATION,
        LIST;

        private static final Map<String, InputType> namesMap;

        @com.fasterxml.jackson.annotation.JsonCreator
        @JsonCreator
        public static InputType forValue(String value) {
            return namesMap.get(StringUtils.lowerCase((String)value));
        }

        @com.fasterxml.jackson.annotation.JsonValue
        @JsonValue
        public String toValue() {
            for (Map.Entry<String, InputType> entry : namesMap.entrySet()) {
                if (entry.getValue() != this) continue;
                return entry.getKey();
            }
            return null;
        }

        public static InputType fromWorkflowParameterType(WorkflowParameterType type) {
            switch (type) {
                case STRING: {
                    return TEXT;
                }
                case USER: {
                    return USER;
                }
                case USERORGROUP: {
                    return USERORGROUP;
                }
                case GROUP: {
                    return GROUP;
                }
                case DURATION: {
                    return DURATION;
                }
                case LIST: {
                    return LIST;
                }
            }
            return TEXT;
        }

        static {
            namesMap = new HashMap<String, InputType>(3);
            namesMap.put("text", TEXT);
            namesMap.put("user", USER);
            namesMap.put("user-or-group", USERORGROUP);
            namesMap.put("userorgroup", USERORGROUP);
            namesMap.put("group", GROUP);
            namesMap.put("duration", DURATION);
            namesMap.put("list", LIST);
        }
    }
}

