/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.workflowNamesRepository.job;

import com.atlassian.core.task.TaskQueue;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.comalatech.confluence.dataextractor.queue.AppfireQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowNameRepositoryQueueJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(WorkflowNameRepositoryQueueJob.class);
    private final AppfireQueueService appfireQueueService;
    public static final String WORKFLOWNAME_REPOSITORY_QUEUE = "workflowname-repository-queue";

    public WorkflowNameRepositoryQueueJob(AppfireQueueService appfireQueueService) {
        this.appfireQueueService = appfireQueueService;
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("WorkflowNameRepositoryQueueJob starting");
        }
        try {
            TaskQueue queue = this.appfireQueueService.getTaskQueue(WORKFLOWNAME_REPOSITORY_QUEUE);
            if (queue == null) {
                queue = this.appfireQueueService.addTaskQueue(WORKFLOWNAME_REPOSITORY_QUEUE);
            }
            if (queue.isFlushing()) {
                log.debug("Task queue {} was already being flushed - skipped this time", (Object)queue);
                return JobRunnerResponse.aborted((String)("Task queue " + queue + " was already being flushed"));
            }
            log.debug("Executing tasks for queue {}, queue size {}", (Object)queue, (Object)queue.size());
            queue.flush();
            log.debug("WorkflowNameRepositoryQueueJob finished! ");
            return JobRunnerResponse.success((String)("Executed tasks for queue " + queue));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JobRunnerResponse.failed((String)"Job failed.");
        }
    }
}

