/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.manager;

import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflow.usage.manager.WorkflowUsageManager;
import com.comalatech.confluence.workflow.usage.rest.model.WorkflowsReport;
import com.comalatech.confluence.workflow.usage.service.WorkflowsUsageReportService;
import com.comalatech.confluence.workflow.usage.task.MetadataWorkflowReportTask;
import com.comalatech.confluence.workflow.usage.task.PageWorkflowReportTask;
import com.comalatech.confluence.workflow.usage.task.RestrictionsContentWorkflowReportTask;
import com.comalatech.confluence.workflow.usage.task.SpaceWorkflowReportTask;
import com.comalatech.confluence.workflow.usage.task.model.Status;
import com.comalatech.confluence.workflow.usage.task.model.WorkflowsUsageTask;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowUsageManager
implements WorkflowUsageManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowUsageManager.class);
    private final WorkflowsUsageReportService workflowsUsageReportService;
    private final SpaceManager spaceManager;
    private final SpaceService spaceService;
    private final LongRunningTaskManager longRunningTaskManager;
    private final ComalaI18nBean comalaI18nBean;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final SupportPresenter templateFileLayoutHelper;
    private final WorkflowService workflowService;

    public DefaultWorkflowUsageManager(WorkflowsUsageReportService workflowsUsageReportService, @ComponentImport SpaceManager spaceManager, @ComponentImport SpaceService spaceService, @ComponentImport LongRunningTaskManager longRunningTaskManager, ComalaI18nBean comalaI18nBean, ReadWriteTransactionService readWriteTransactionService, SupportPresenter templateFileLayoutHelper, WorkflowService workflowService) {
        this.workflowsUsageReportService = workflowsUsageReportService;
        this.spaceManager = spaceManager;
        this.spaceService = spaceService;
        this.longRunningTaskManager = longRunningTaskManager;
        this.comalaI18nBean = comalaI18nBean;
        this.readWriteTransactionService = readWriteTransactionService;
        this.templateFileLayoutHelper = templateFileLayoutHelper;
        this.workflowService = workflowService;
    }

    @Override
    public WorkflowsUsageTask launchPageWorkflowsReport() {
        WorkflowsUsageTask workflowsUsageTask = this.workflowsUsageReportService.getPageWorkflowsUsageReportTask();
        if (workflowsUsageTask != null && Status.IN_PROGRESS.equals((Object)workflowsUsageTask.getStatus())) {
            String taskId = workflowsUsageTask.getLongRunningTaskId();
            LongRunningTaskId longRunningTaskId = LongRunningTaskId.from((LongTaskId)LongTaskId.deserialise((String)taskId));
            LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), longRunningTaskId);
            if (longRunningTask == null) {
                workflowsUsageTask.setStatus(Status.FAIL);
                this.workflowsUsageReportService.savePageWorkflowsUsageReportTask(workflowsUsageTask);
                log.error("There is no long running task in progress for the page workflows usage report.");
            }
            return workflowsUsageTask;
        }
        workflowsUsageTask = this.initWorkflowUsageTaskProperties();
        PageWorkflowReportTask pageWorkflowsReportTask = new PageWorkflowReportTask(this.spaceManager, this.spaceService, this.workflowsUsageReportService, this.comalaI18nBean, this.readWriteTransactionService, this.templateFileLayoutHelper, workflowsUsageTask);
        LongRunningTaskId longRunningTaskId = this.longRunningTaskManager.startLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), (LongRunningTask)pageWorkflowsReportTask);
        if (longRunningTaskId != null) {
            workflowsUsageTask.setLongRunningTaskId(longRunningTaskId.asLongTaskId().serialise());
            this.workflowsUsageReportService.savePageWorkflowsUsageReportTask(workflowsUsageTask);
        } else {
            log.debug("Workflows usage report task did not start, no long running task id was identified.");
        }
        return workflowsUsageTask;
    }

    @Override
    public WorkflowsUsageTask launchSpaceWorkflowsReport() {
        WorkflowsUsageTask workflowsUsageTask = this.workflowsUsageReportService.getSpaceWorkflowsUsageReportTask();
        if (workflowsUsageTask != null && Status.IN_PROGRESS.equals((Object)workflowsUsageTask.getStatus())) {
            String taskId = workflowsUsageTask.getLongRunningTaskId();
            if (taskId != null) {
                LongRunningTaskId longRunningTaskId = LongRunningTaskId.from((LongTaskId)LongTaskId.deserialise((String)taskId));
                LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), longRunningTaskId);
                if (longRunningTask == null) {
                    workflowsUsageTask.setStatus(Status.FAIL);
                    this.workflowsUsageReportService.saveSpaceWorkflowsUsageReportTask(workflowsUsageTask);
                    log.error("There is no long running task in progress for the space workflows usage report.");
                }
            } else {
                workflowsUsageTask.setStatus(Status.FAIL);
                this.workflowsUsageReportService.saveSpaceWorkflowsUsageReportTask(workflowsUsageTask);
                log.error("There is no long running task in progress for the space workflows usage report.");
            }
            return workflowsUsageTask;
        }
        workflowsUsageTask = this.initWorkflowUsageTaskProperties();
        SpaceWorkflowReportTask spaceWorkflowReportTask = new SpaceWorkflowReportTask(this.spaceManager, this.spaceService, this.workflowsUsageReportService, this.comalaI18nBean, this.readWriteTransactionService, this.templateFileLayoutHelper, workflowsUsageTask);
        LongRunningTaskId longRunningTaskId = this.longRunningTaskManager.startLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), (LongRunningTask)spaceWorkflowReportTask);
        if (longRunningTaskId != null) {
            workflowsUsageTask.setLongRunningTaskId(longRunningTaskId.asLongTaskId().serialise());
            this.workflowsUsageReportService.saveSpaceWorkflowsUsageReportTask(workflowsUsageTask);
        } else {
            log.debug("Workflows usage report task did not start, no long running task id was identified.");
        }
        return workflowsUsageTask;
    }

    @Override
    public WorkflowsUsageTask launchRestrictionsWorkflowsReport() {
        LongRunningTaskId longRunningTaskId;
        WorkflowsUsageTask workflowsUsageTask = this.workflowsUsageReportService.getRestrictionsWorkflowUsageReportTask();
        if (workflowsUsageTask != null && Status.IN_PROGRESS.equals((Object)workflowsUsageTask.getStatus())) {
            String taskId = workflowsUsageTask.getLongRunningTaskId();
            longRunningTaskId = LongRunningTaskId.from((LongTaskId)LongTaskId.deserialise((String)taskId));
            LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), longRunningTaskId);
            if (longRunningTask == null) {
                workflowsUsageTask.setStatus(Status.FAIL);
                this.workflowsUsageReportService.saveRestrictionsWorkflowsUsageReportTask(workflowsUsageTask);
                log.error("There is no long running task in progress for the content restriction report.");
            }
        }
        workflowsUsageTask = this.initWorkflowUsageTaskProperties();
        RestrictionsContentWorkflowReportTask restrictionsWorkflowReportTask = new RestrictionsContentWorkflowReportTask(this.spaceManager, this.workflowService, this.workflowsUsageReportService, this.comalaI18nBean, this.readWriteTransactionService, this.templateFileLayoutHelper, workflowsUsageTask);
        longRunningTaskId = this.longRunningTaskManager.startLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), (LongRunningTask)restrictionsWorkflowReportTask);
        workflowsUsageTask.setLongRunningTaskId(longRunningTaskId.asLongTaskId().serialise());
        this.workflowsUsageReportService.saveRestrictionsWorkflowsUsageReportTask(workflowsUsageTask);
        return workflowsUsageTask;
    }

    @Override
    public WorkflowsUsageTask launchMetadataReport() {
        LongRunningTaskId longRunningTaskId;
        WorkflowsUsageTask workflowsUsageTask = this.workflowsUsageReportService.getMetadataUsageReportTask();
        if (workflowsUsageTask != null && Status.IN_PROGRESS.equals((Object)workflowsUsageTask.getStatus())) {
            String taskId = workflowsUsageTask.getLongRunningTaskId();
            longRunningTaskId = LongRunningTaskId.from((LongTaskId)LongTaskId.deserialise((String)taskId));
            LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), longRunningTaskId);
            if (longRunningTask == null) {
                workflowsUsageTask.setStatus(Status.FAIL);
                this.workflowsUsageReportService.saveMetadataWorkflowsUsageReportTask(workflowsUsageTask);
                log.error("There is no long running task in progress for the metadata report.");
            }
        }
        workflowsUsageTask = this.initWorkflowUsageTaskProperties();
        MetadataWorkflowReportTask metadataWorkflowReportTask = new MetadataWorkflowReportTask(this.spaceManager, this.workflowService, this.workflowsUsageReportService, this.comalaI18nBean, this.readWriteTransactionService, this.templateFileLayoutHelper, workflowsUsageTask);
        longRunningTaskId = this.longRunningTaskManager.startLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), (LongRunningTask)metadataWorkflowReportTask);
        workflowsUsageTask.setLongRunningTaskId(longRunningTaskId.asLongTaskId().serialise());
        this.workflowsUsageReportService.saveMetadataWorkflowsUsageReportTask(workflowsUsageTask);
        return workflowsUsageTask;
    }

    @Override
    public void cancelWorkflowUsageReport(String type) {
        if (WorkflowsReport.PAGE.getName().equals(type)) {
            this.workflowsUsageReportService.savePageWorkflowsUsageReportTask(this.stopWorkflowUsageTaskProperties());
        } else if (WorkflowsReport.SPACE.getName().equals(type)) {
            this.workflowsUsageReportService.saveSpaceWorkflowsUsageReportTask(this.stopWorkflowUsageTaskProperties());
        } else if (WorkflowsReport.RESTRICTIONS.getName().equals(type)) {
            this.workflowsUsageReportService.saveRestrictionsWorkflowsUsageReportTask(this.stopWorkflowUsageTaskProperties());
        } else if (WorkflowsReport.METADATA.getName().equals(type)) {
            this.workflowsUsageReportService.saveMetadataWorkflowsUsageReportTask(this.stopWorkflowUsageTaskProperties());
        } else {
            log.error("Unknown workflow report type for cancel request: {}", (Object)type);
        }
    }

    private WorkflowsUsageTask initWorkflowUsageTaskProperties() {
        return new WorkflowsUsageTask(Status.IN_PROGRESS, TimerUtils.toEpochMilli(LocalDateTime.now()), null, null, 0, null);
    }

    private WorkflowsUsageTask stopWorkflowUsageTaskProperties() {
        return new WorkflowsUsageTask(Status.CANCEL, null, null, null, null, null);
    }
}

