/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rules.validation;

import com.comalatech.confluence.workflow.rules.validation.VerificationRule;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IsInSevenDaysPeriod
implements VerificationRule<String> {
    private static final Logger log = LoggerFactory.getLogger(IsInSevenDaysPeriod.class);

    @Override
    public boolean validate(String date) {
        return this.dateIsInsideSevenDaysInterval(date);
    }

    private boolean dateIsInsideSevenDaysInterval(String dateSeenString) {
        try {
            LocalDateTime savedShownDate = LocalDateTime.parse(dateSeenString);
            LocalDateTime pageShownAfterSevenDays = savedShownDate.plus(7L, ChronoUnit.DAYS);
            return LocalDateTime.now().isBefore(pageShownAfterSevenDays);
        }
        catch (Exception e) {
            log.debug("Cannot parse date {} , {}", (Object)dateSeenString, (Object)e);
            return false;
        }
    }
}

