/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.activeobjects.accessor.QueuedJobEntityAccessor;
import com.comalatech.confluence.workflow.macros.actions.AbstractActionMacro;
import com.comalatech.confluence.workflow.tasks.manager.QueuedJobManager;
import com.comalatech.confluence.workflow.tasks.model.WorkflowLabelledActionModel;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractLabelMacro
extends AbstractActionMacro {
    @ComponentImport
    protected LabelManager labelManager;
    private QueuedJobManager queuedJobManager;
    public static final String PARAM_0 = "0";
    public static final String PARAM_LABELNAME = "label";
    public static final String PARAM_CHILDREN = "children";

    public abstract void doLabelAction(Label var1, AbstractPage var2, boolean var3) throws WorkflowException;

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String labelName = (String)parameters.get(PARAM_0);
        if (!StringUtils.isNotBlank((CharSequence)labelName)) {
            labelName = (String)parameters.get(PARAM_LABELNAME);
        }
        if (!StringUtils.isNotBlank((CharSequence)labelName)) {
            throw new MacroException("must define a label");
        }
        boolean children = Boolean.TRUE.toString().equals(parameters.get(PARAM_CHILDREN));
        ValueStore valueStore = (ValueStore)renderContext.getParam((Object)"valueStore");
        if (LabelParser.parse((String)labelName) == null && !labelName.startsWith("@")) {
            throw new MacroException("invalid label name " + labelName + ": it should not include " + LabelParser.getInvalidCharactersAsString());
        }
        if (!this.inExecuteMode(renderContext)) {
            return "";
        }
        try {
            labelName = valueStore.getValue(labelName);
            if (StringUtils.isBlank((CharSequence)labelName)) {
                throw new WorkflowException("invalid label name: " + labelName);
            }
            if (LabelParser.parse((String)labelName) == null) {
                throw new WorkflowException("invalid label name " + labelName + ": it should not include " + LabelParser.getInvalidCharactersAsString());
            }
            AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
            Label label = this.makeLabel(labelName);
            this.doLabelAction(label, page, children);
        }
        catch (Exception e) {
            this.logMessage(renderContext, e);
        }
        return "";
    }

    protected void defferLabelActionToChildren(AbstractPage page, Label label, boolean add) {
        if (!(page instanceof Page)) {
            return;
        }
        List children = ((Page)page).getChildren();
        for (Page child : children) {
            if (child.getParent().getId() != page.getId()) continue;
            this.queuedJobManager.addToQueue(QueuedJobEntityAccessor.JobType.WORKFLOW_LABELLED_ACTION, new WorkflowLabelledActionModel(child.getId(), AuthenticatedUserThreadLocal.getUsername(), label.getName(), add, WorkflowAuthenticatedUserThreadLocal.isInExpiryJob()));
        }
    }

    private Label makeLabel(String labelName) {
        ParsedLabelName parsedLabel = LabelParser.parse((String)labelName);
        return parsedLabel.toLabel();
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setQueuedJobManager(QueuedJobManager queuedJobManager) {
        this.queuedJobManager = queuedJobManager;
    }
}

