/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.user.User;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;

public class ESignaturesAction
extends ConfluenceActionSupport {
    @ComponentImport
    private WikiStyleRenderer wikiStyleRenderer;
    private AdhocWorkflowsLicenseManager licenseManager;
    private WorkflowStatisticsManager workflowStatisticsManager;
    private String docoUrlCDM = "https://apps.appf.re/cdmdc/doc/glbalconfigesignatures/l3sdBi";
    private String docoUrlCDC = "https://apps.appf.re/cdcdc/doc/globaladmin/AVMT5M";
    private String esignatureUrlCDM = "https://apps.appf.re/cdmdc/doc/userguideesignature/5y82fH";
    private String esignatureUrlCDC = "https://apps.appf.re/cdcdc/doc/esignatures/rWJh7I";

    public String execute() throws Exception {
        return "success";
    }

    public String render(String body) {
        PageContext context = new PageContext();
        context.pushRenderMode(RenderMode.suppress((long)1L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, body);
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public void setLicenseManager(AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setWorkflowStatisticsManager(WorkflowStatisticsManager workflowStatisticsManager) {
        this.workflowStatisticsManager = workflowStatisticsManager;
    }

    public WorkflowStatisticsManager getWorkflowStatisticsManager() {
        return this.workflowStatisticsManager;
    }

    public String getDocoUrl(String app) {
        return app.equalsIgnoreCase("cdc") ? this.docoUrlCDC : this.docoUrlCDM;
    }

    public String getEsignatureUrl(String app) {
        return app.equalsIgnoreCase("cdc") ? this.esignatureUrlCDC : this.esignatureUrlCDM;
    }
}

