/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.audit.listener;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.notification.events.WorkflowNotificationConfigurationUpdatedEventImpl;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.audit.model.AuditRecord;
import com.comalatech.confluence.workflow.audit.model.PageAuditRecord;
import com.comalatech.confluence.workflow.audit.model.SpaceAuditRecord;
import com.comalatech.confluence.workflow.audit.service.AuditService;
import com.comalatech.confluence.workflow.events.AbstractPageWorkflowEvent;
import com.comalatech.confluence.workflow.events.AbstractPageWorkflowHistoryClearedEvent;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowConfigurationUpdatedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowParameterEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowParameterUpdatedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowPropertiesPopulatedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowStatesInitializationEventImpl;
import com.comalatech.workflow.event.WorkflowSpaceEvent;
import com.comalatech.workflow.event.admin.SpaceWorkflowHistoryClearedEvent;
import com.comalatech.workflow.event.admin.SpaceWorkflowNotificationConfigurationUpdatedEvent;
import com.comalatech.workflow.event.admin.WorkflowAdvancedConfigurationUpdatedEvent;
import com.comalatech.workflow.event.admin.WorkflowChangeEvent;
import com.comalatech.workflow.event.admin.WorkflowConfigurationUpdatedEvent;
import java.util.Date;
import java.util.Map;

public class AuditEventListener
extends WorkflowsListener {
    private final SpaceManager spaceManager;
    private final AuditService workflowAuditService;

    public AuditEventListener(@ComponentImport EventPublisher eventPublisher, AuditService workflowAuditService, @ComponentImport SpaceManager spaceManager) {
        super(eventPublisher);
        this.workflowAuditService = workflowAuditService;
        this.spaceManager = spaceManager;
    }

    @EventListener
    public void onConfigUpdated(WorkflowConfigurationUpdatedEvent event) {
        this.workflowAuditService.addRecord(this.createGlobalChangeAuditRecord(event, event.getOldConfig(), event.getConfig()));
    }

    @EventListener
    public void onSpaceConfigUpdated(SpaceWorkflowConfigurationUpdatedEventImpl event) {
        this.workflowAuditService.addRecord(this.createSpaceChangeAuditRecord(event, event.getSpace().getKey(), event.getOldSpaceConfig(), event.getSpaceConfig()));
    }

    @EventListener
    public void onSpaceWorkflowStatesInitializationEvent(SpaceWorkflowStatesInitializationEventImpl event) {
        this.workflowAuditService.addRecord(this.createSpaceChangeAuditRecord(event, event.getSpace().getKey(), null, event.getParamsMap()));
    }

    @EventListener
    public void onSpaceParameterEvent(SpaceWorkflowParameterEventImpl event) {
        if (event instanceof SpaceWorkflowParameterUpdatedEventImpl) {
            this.workflowAuditService.addRecord(this.createSpaceChangeAuditRecord(event, event.getSpace().getKey(), ((SpaceWorkflowParameterUpdatedEventImpl)event).getOldParameterConfig(), event.getParameterConfig()));
        } else {
            this.workflowAuditService.addRecord(this.createSpaceChangeAuditRecord(event, event.getSpace().getKey(), null, event.getParameterConfig()));
        }
    }

    @EventListener
    public void onNotificationConfigEvent(WorkflowNotificationConfigurationUpdatedEventImpl event) {
        if (event instanceof SpaceWorkflowNotificationConfigurationUpdatedEvent) {
            this.workflowAuditService.addRecord(this.createSpaceChangeAuditRecord(event, ((SpaceWorkflowNotificationConfigurationUpdatedEvent)((Object)event)).getSpace().getKey(), null, event.getConfig()));
        } else {
            this.workflowAuditService.addRecord(this.createGlobalChangeAuditRecord(event, null, event.getConfig()));
        }
    }

    @EventListener
    public void onWorkflowChangedEvent(WorkflowChangeEvent event) {
        if (event.getWorkflow() == null) {
            return;
        }
        AuditRecord record = event instanceof WorkflowSpaceEvent ? this.createSpaceAuditRecord((WorkflowSpaceEvent)((Object)event), event.getWorkflow().getName()) : (event instanceof AbstractPageWorkflowEvent ? this.createPageAuditRecord((AbstractPageWorkflowEvent)((Object)event), event.getWorkflow().getName()) : this.createGlobalAuditRecord(event, event.getWorkflow().getName()));
        this.workflowAuditService.addRecord(record);
    }

    @EventListener
    public void onSpaceWorkflowHistoryClearedEvent(SpaceWorkflowHistoryClearedEvent event) {
        this.workflowAuditService.addRecord(this.createSpaceAuditRecord(event, ""));
    }

    @EventListener
    public void onPageWorkflowHistoryClearedEvent(AbstractPageWorkflowHistoryClearedEvent event) {
        this.workflowAuditService.addRecord(this.createPageAuditRecord(event, ""));
    }

    @EventListener
    public void onSpaceWorkflowPropertiesPopulatedEvent(SpaceWorkflowPropertiesPopulatedEventImpl event) {
        this.workflowAuditService.addRecord(this.createSpaceAuditRecord(event, ""));
    }

    @EventListener
    public void onWorkflowAdvancedConfigUpdated(WorkflowAdvancedConfigurationUpdatedEvent event) {
        this.workflowAuditService.addRecord(this.createGlobalChangeAuditRecord(event, event.getOldConfig(), event.getConfig()));
    }

    protected AuditRecord createGlobalChangeAuditRecord(Object event, Map<String, String> oldValues, Map<String, String> newValues) {
        return new AuditRecord(new Date(), AuthenticatedUserThreadLocal.get().getKey().getStringValue(), event.getClass().getSimpleName(), oldValues, newValues);
    }

    protected AuditRecord createGlobalAuditRecord(Object event, String description) {
        return new AuditRecord(new Date(), AuthenticatedUserThreadLocal.get().getKey().getStringValue(), event.getClass().getSimpleName(), description);
    }

    protected AuditRecord createSpaceChangeAuditRecord(Object event, String spaceKey, Map<String, String> oldValues, Map<String, String> newValues) {
        Space space = this.spaceManager.getSpace(spaceKey);
        return new SpaceAuditRecord(new Date(), AuthenticatedUserThreadLocal.get().getKey().getStringValue(), event.getClass().getSimpleName(), oldValues, newValues, space);
    }

    protected AuditRecord createSpaceAuditRecord(WorkflowSpaceEvent event, String description) {
        Space space = this.spaceManager.getSpace(event.getSpace().getKey());
        return new SpaceAuditRecord(new Date(), AuthenticatedUserThreadLocal.get().getKey().getStringValue(), event.getClass().getSimpleName(), description, space);
    }

    protected AuditRecord createPageAuditRecord(AbstractPageWorkflowEvent event, String description) {
        Space space = this.spaceManager.getSpace(event.getContent().getSpaceKey());
        return new PageAuditRecord(new Date(), AuthenticatedUserThreadLocal.get().getKey().getStringValue(), event.getClass().getSimpleName(), description, space, (ContentEntityObject)event.getContent());
    }
}

