/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.dataextractor;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.readack.ReadAckException;
import com.comalatech.confluence.readack.mapper.ReadAckContentPropertyModelMapper;
import com.comalatech.confluence.readack.model.ReadAckContentPropertyModel;
import com.comalatech.confluence.readack.model.ReadAckPageStatus;
import com.comalatech.confluence.readack.service.ReadAckManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReadAckPropertyExtractor {
    private static final Logger log = LoggerFactory.getLogger(ReadAckPropertyExtractor.class);
    private final ReadAckManager readAckManager;
    private final WorkflowPermissionManager workflowPermissionManager;

    public ReadAckPropertyExtractor(ReadAckManager readAckManager, WorkflowPermissionManager workflowPermissionManager) {
        this.readAckManager = readAckManager;
        this.workflowPermissionManager = workflowPermissionManager;
    }

    public String getJsonOf(AbstractPage page) {
        ReadAckContentPropertyModel data = this.extractFrom(page);
        return data != null ? ReadAckPropertyExtractor.serialize(data) : null;
    }

    private ReadAckContentPropertyModel extractFrom(AbstractPage page) {
        String readAckStatus = "";
        Integer pendingUsers = null;
        Integer ackUsers = null;
        Date dueDate = null;
        ReadAckPageStatus readAckPageStatus = null;
        try {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            boolean canViewWorkflows = this.workflowPermissionManager.canViewWorkflows(page.getSpace(), user);
            readAckPageStatus = this.readAckManager.getPageStatus(page, canViewWorkflows, true);
            if (readAckPageStatus != null) {
                readAckStatus = readAckPageStatus.getPageStatus().toString();
                pendingUsers = readAckPageStatus.getPendingUsers();
                ackUsers = readAckPageStatus.getAckUsers();
                if (readAckPageStatus.getDueDate() != null) {
                    dueDate = new Date(readAckPageStatus.getDueDate());
                }
            }
        }
        catch (ReadAckException raEx) {
            log.error("Problems getting the read ack status related to " + page, (Throwable)raEx);
        }
        ReadAckContentPropertyModel contentPropertyModel = new ReadAckContentPropertyModel();
        contentPropertyModel.readAckStatus = readAckStatus;
        contentPropertyModel.ackUsers = ackUsers;
        contentPropertyModel.pendingUsers = pendingUsers;
        contentPropertyModel.readAckDueDate = dueDate;
        return contentPropertyModel;
    }

    private static String serialize(ReadAckContentPropertyModel data) {
        try {
            return ReadAckContentPropertyModelMapper.map(data);
        }
        catch (Exception e) {
            log.error("ReadAckContentPropertyModel could not be serialised", (Throwable)e);
            return null;
        }
    }

    public static ReadAckContentPropertyModel deserialize(String jsonCP) {
        try {
            return ReadAckContentPropertyModelMapper.map(jsonCP);
        }
        catch (WorkflowException e) {
            return null;
        }
    }
}

