/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.onboard;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.user.User;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.onboard.OnboardingManager;
import com.comalatech.confluence.onboard.accessor.SpaceAccessor;
import com.comalatech.confluence.util.keys.OnBoardKeys;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.rest.model.RestSpace;
import com.comalatech.confluence.workflow.rules.permission.PermissionRule;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultOnboardingManager
implements OnboardingManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultOnboardingManager.class);
    private final UserAccessor userAccessor;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final PermissionRule<AbstractPage> hasPageWorkflow;
    private final PermissionRule<AbstractPage> canHavePageWorkflow;
    private final PermissionRule<Space> canAddSpaceWorkflow;
    private final DarkFeatureManager darkFeatureManager;
    private final AdhocWorkflowsLicenseManager workflowsLicenseManager;
    private final SpaceManager spaceManager;
    private final SpaceAccessor spaceAccessor;
    private final String pageHideCheck;

    public DefaultOnboardingManager(@ComponentImport UserAccessor userAccessor, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, @Qualifier(value="hasPageWorkflow") PermissionRule<AbstractPage> hasPageWorkflow, @Qualifier(value="canHavePageWorkflow") PermissionRule<AbstractPage> canHavePageWorkflow, @Qualifier(value="canAddSpaceWorkflow") PermissionRule<Space> canAddSpaceWorkflow, @ComponentImport DarkFeatureManager darkFeatureManager, AdhocWorkflowsLicenseManager workflowsLicenseManager, @ComponentImport SpaceManager spaceManager, SpaceAccessor spaceAccessor) {
        this.userAccessor = userAccessor;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.hasPageWorkflow = hasPageWorkflow;
        this.canHavePageWorkflow = canHavePageWorkflow;
        this.canAddSpaceWorkflow = canAddSpaceWorkflow;
        this.darkFeatureManager = darkFeatureManager;
        this.workflowsLicenseManager = workflowsLicenseManager;
        this.spaceManager = spaceManager;
        this.spaceAccessor = spaceAccessor;
        this.pageHideCheck = OnBoardKeys.PAGE_HIDE_CHECK + "-" + workflowsFeatureManager.getPluginKey();
    }

    @Override
    public boolean showPage(ConfluenceUser user, AbstractPage page) {
        boolean onBoardEnable;
        if (page == null) {
            return false;
        }
        boolean bl = onBoardEnable = this.workflowConfigurationManager.isOnboardEnabled() && this.workflowsLicenseManager.isLicensed();
        if (this.darkFeatureManager.isEnabledForAllUsers("comalatech.workflows.onboarding.force.show.items").orElse(false).booleanValue()) {
            return onBoardEnable;
        }
        if (Duration.between(page.getLastModificationDate().toInstant(), Instant.now()).toMillis() > Duration.ofDays(1L).toMillis()) {
            return false;
        }
        if (!onBoardEnable) {
            return false;
        }
        if (user != null && page.getCreator() != null && !page.getCreator().equals(user)) {
            return false;
        }
        if (!this.hasPermission(page)) {
            return false;
        }
        if (!this.workflowsFeatureManager.isNewInstallation()) {
            return false;
        }
        UserPreferences userPreferences = this.userAccessor.getUserPreferences((User)user);
        if (userPreferences == null) {
            return false;
        }
        boolean panelShouldBeHidden = userPreferences.getBoolean(this.pageHideCheck);
        return !panelShouldBeHidden;
    }

    @Override
    public void savePageHideCheck(ConfluenceUser user) throws AtlassianCoreException {
        this.userAccessor.getUserPreferences((User)user).setBoolean(this.pageHideCheck, true);
    }

    @Override
    public List<RestSpace> getSpacesForCurrentUser(String name) {
        return this.spaceAccessor.getAvailableSpacesByName(name).stream().filter(Objects::nonNull).filter(spaceEntry -> {
            try {
                Space space = new Space();
                space.setId(spaceEntry.getId().longValue());
                space.setName(spaceEntry.getName());
                space.setKey(spaceEntry.getKey());
                return this.canAddSpaceWorkflow.validate(space);
            }
            catch (Exception e) {
                log.error("Error while checking space permission", (Throwable)e);
                return false;
            }
        }).map(space -> new RestSpace(space.getName(), space.getKey())).collect(Collectors.toList());
    }

    private boolean hasPermission(AbstractPage page) {
        return !this.hasPageWorkflow.validate(page) && this.canHavePageWorkflow.validate(page);
    }
}

