/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.license;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.comalatech.confluence.license.ComalaDocumentAppManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultComalaDocumentAppManager
implements ComalaDocumentAppManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultComalaDocumentAppManager.class);
    private final PluginLicenseManager pluginLicenseManager;
    private final PluginAccessor pluginAccessor;
    private static final String COMALA_DOCUMENT_MANAGEMENT = "com.comalatech.workflow";
    private static final String COMALA_DOCUMENT_CONTROL = "com.comalatech.cloud.approvals";
    private static final String COMALA_DOCUMENT_APPROVAL = "com.comalatech.workflow.approvals";
    private static final String COMALA_DOCUMENT_MANAGEMENT_ACRONYM = "CDM";
    private static final String COMALA_DOCUMENT_CONTROL_ACRONYM = "CDC";
    private static final String COMALA_DOCUMENT_APPROVAL_ACRONYM = "CDA";

    public DefaultComalaDocumentAppManager(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PluginAccessor pluginAccessor) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public String getPluginKey() {
        return this.pluginLicenseManager.getPluginKey();
    }

    @Override
    public String getVersionNumber() {
        PluginInformation pluginInformation = this.pluginAccessor.getEnabledPlugin(this.getPluginKey()).getPluginInformation();
        if (pluginInformation != null) {
            return pluginInformation.getVersion();
        }
        log.error("There has been an error retrieving the app version.");
        return null;
    }

    @Override
    public String getAppInfo() {
        if (this.getAcronym() != null) {
            return this.getAcronym() + "_" + this.getVersionNumber();
        }
        log.error("There has been an error retrieving the app info.");
        return null;
    }

    private String getAcronym() {
        String pluginKey;
        switch (pluginKey = this.getPluginKey()) {
            case "com.comalatech.workflow": {
                return COMALA_DOCUMENT_MANAGEMENT_ACRONYM;
            }
            case "com.comalatech.workflow.approvals": {
                return COMALA_DOCUMENT_APPROVAL_ACRONYM;
            }
            case "com.comalatech.cloud.approvals": {
                return COMALA_DOCUMENT_CONTROL_ACRONYM;
            }
        }
        log.error("There has been an error retrieving the acronym of the plugin.");
        return null;
    }
}

