/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor.builder.report;

import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.FilterBuilder;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryScope;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQueryFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.java.ao.Query;

public class ScopeFilterBuilder
implements FilterBuilder {
    private final SpaceManager spaceManager;

    public ScopeFilterBuilder(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    @Override
    public Query build(InternalDocumentActivityQuery query) {
        return this.getQuery(query, false);
    }

    @Override
    public Query build(InternalDocumentActivityQuery query, boolean aliasRequired) {
        return this.getQuery(query, aliasRequired);
    }

    private Query getQuery(InternalDocumentActivityQuery query, boolean aliasRequired) {
        InternalDocumentActivityQueryFilter filters = (InternalDocumentActivityQueryFilter)query.getFilters();
        if (Objects.isNull(filters) || Objects.isNull(filters.getScope())) {
            return null;
        }
        DocumentActivityQueryScope scope = filters.getScope();
        ArrayList<Object> values = new ArrayList<Object>();
        if (scope.getPageIds() != null && !scope.getPageIds().isEmpty()) {
            List<Long> pageIds = scope.getPageIds();
            return this.generateScopeFilterQuery(aliasRequired, values, pageIds, "PAGE_ID");
        }
        if (scope.getSpaceKeys() != null && !scope.getSpaceKeys().isEmpty()) {
            ArrayList<Long> spaceIds = new ArrayList<Long>();
            scope.getSpaceKeys().forEach(key -> spaceIds.add(this.spaceManager.getSpace(key).getId()));
            return this.generateScopeFilterQuery(aliasRequired, values, spaceIds, "SPACE_ID");
        }
        return null;
    }

    private Query generateScopeFilterQuery(boolean aliasRequired, List<Object> values, List<Long> scopeIds, String queryField) {
        String placeholder = scopeIds.stream().map(s -> "?").collect(Collectors.joining(","));
        String clause = (aliasRequired ? "activity." : "") + queryField + " IN (" + placeholder + ")";
        values.addAll(scopeIds);
        return Query.select().where(clause, values.toArray());
    }

    @Override
    public boolean shouldApply(InternalDocumentActivityQuery query) {
        InternalDocumentActivityQueryFilter filters = (InternalDocumentActivityQueryFilter)query.getFilters();
        return filters != null && filters.getScope() != null && (filters.getScope().getPageIds() != null && !filters.getScope().getPageIds().isEmpty() || filters.getScope().getSpaceKeys() != null && !filters.getScope().getSpaceKeys().isEmpty());
    }
}

