/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.app.disco.TransferInfo;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.entity.domain.metadata.Metadata;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.MigrationEntity;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.metadata.MetadataMigration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.metadata.MetadataMigrationEntity;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.pageactivity.PageActivityMigrationEntity;
import com.comalatech.confluence.cloud.migration.usecases.MigrationLabel;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudMappingsData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.ContentMigrationProcessor;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageMetadataMigrationData;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import com.comalatech.confluence.workflow.WorkflowService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="metadataMigrationProcessor")
public class MetadataMigrationProcessor
implements ContentMigrationProcessor {
    private static final Logger log = LoggerFactory.getLogger(MetadataMigrationProcessor.class);
    private static final String METADATA_MIGRATION_VERSION = "1";
    private static final String BLOGS = "blog";
    private static final String PAGES = "pages";
    private static final String USERS = "users";
    private static final String GROUPS = "groups";
    private final PageManager pageManager;
    private final CloudPopulationData<Metadata> userPopulationData;
    private final CloudPopulationData<Metadata> groupPopulationData;
    private final CloudMappingsData cloudMappingsData;
    private final ContentPermissionManager contentPermissionManager;
    private final SystemInformationService systemInformationService;
    private final GeneratePageMetadataMigrationData pageMetadataGeneratorUseCase;
    private final WorkflowService workflowService;
    private final UserAccessor userAccessor;

    public MetadataMigrationProcessor(@Qualifier(value="cloudMetadataUserIdPopulationUseCase") CloudPopulationData<Metadata> userPopulationData, @Qualifier(value="cloudMetadataGroupIdPopulationUseCase") CloudPopulationData<Metadata> groupPopulationData, CloudMappingsData cloudMappingsData, @ComponentImport PageManager pageManager, @ComponentImport ContentPermissionManager contentPermissionManager, @ComponentImport SystemInformationService systemInformationService, GeneratePageMetadataMigrationData pageMetadataGeneratorUseCase, WorkflowService workflowService, UserAccessor userAccessor) {
        this.userPopulationData = userPopulationData;
        this.groupPopulationData = groupPopulationData;
        this.cloudMappingsData = cloudMappingsData;
        this.pageManager = pageManager;
        this.contentPermissionManager = contentPermissionManager;
        this.systemInformationService = systemInformationService;
        this.pageMetadataGeneratorUseCase = pageMetadataGeneratorUseCase;
        this.workflowService = workflowService;
        this.userAccessor = userAccessor;
    }

    @Override
    public <T> Migration process(AppCloudMigrationGateway gateway, Map<AbstractPage, T> pageMetadata, TransferInfo transferInfo, MigrationDetailsV1 migrationDetails) throws Exception {
        Map<AbstractPage, List<Metadata>> _pageMetadata = pageMetadata;
        String transferId = transferInfo.getTransferId().toString();
        Map<String, Set<String>> localIds = this.idExtractor(_pageMetadata);
        Map<String, String> contentMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.CONFLUENCE_PAGES.toString(), localIds.get(PAGES));
        Map<String, String> blogPostMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.CONFLUENCE_BLOGPOST.toString(), localIds.get(BLOGS));
        Map<String, String> userMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.USERS_KEY.toString(), localIds.get(USERS));
        Map<String, String> groupMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.GROUP_NAME_PREFIX.toString(), localIds.get(GROUPS));
        contentMapping.putAll(blogPostMapping);
        Migration cloudMigration = new Migration();
        _pageMetadata.entrySet().parallelStream().forEach(content -> {
            String cloudContentKey = (String)contentMapping.get(String.valueOf(((AbstractPage)content.getKey()).getId()));
            if (cloudContentKey == null) {
                log.error("Cloud mapping for {} not found", (Object)((AbstractPage)content.getKey()).getId());
            }
            List<Metadata> metadataMapped = ((List)content.getValue()).stream().map(metadata -> this.userPopulationData.populateCloudData((Metadata)metadata, userMapping)).map(metadata -> this.groupPopulationData.populateCloudData((Metadata)metadata, groupMapping)).collect(Collectors.toList());
            cloudMigration.migrationEntities.add(this.populateMigrationEntity((AbstractPage)content.getKey(), cloudContentKey, metadataMapped));
        });
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = METADATA_MIGRATION_VERSION;
        cloudMigration.label = MigrationLabel.METADATA.getLabel();
        return cloudMigration;
    }

    @Override
    public Migration debug(List<String> spaceKeys) throws Exception {
        return null;
    }

    @Override
    public Migration debug(AbstractPage content) throws Exception {
        Migration cloudMigration = new Migration();
        Map<AbstractPage, List<Metadata>> contentMetadataMap = this.pageMetadataGeneratorUseCase.generatePageMetadata(content.getSpaceKey(), true, !this.workflowService.getSpacesWithWorkflows(Set.of(content.getSpaceKey())).isEmpty());
        List<Metadata> contentMetadata = contentMetadataMap.get(content);
        if (contentMetadata != null) {
            cloudMigration.migrationEntities.add(this.populateMigrationEntity(content, String.valueOf(content.getId()), contentMetadata));
        }
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = METADATA_MIGRATION_VERSION;
        return cloudMigration;
    }

    private Map<String, Set<String>> idExtractor(Map<AbstractPage, List<Metadata>> pageMetadata) {
        ConcurrentHashMap.KeySetView pagesID = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView blogPostID = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView usersID = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView groupsID = ConcurrentHashMap.newKeySet();
        pageMetadata.entrySet().parallelStream().forEach(content -> {
            AbstractPage abstractPage = (AbstractPage)content.getKey();
            if (abstractPage instanceof Page) {
                pagesID.add(String.valueOf(abstractPage.getId()));
            } else {
                blogPostID.add(String.valueOf(abstractPage.getId()));
            }
            List contentMetadata = (List)content.getValue();
            contentMetadata.stream().filter(metadata -> metadata.getType() != null).filter(metadata -> metadata.getValue() != null && !metadata.getValue().isEmpty()).forEach(metadata -> {
                if (metadata.getType().equals((Object)Metadata.ContentType.WORKFLOW_PARAMETER_GROUP)) {
                    String value = metadata.getValue();
                    if (value.contains(",")) {
                        String[] groupNames;
                        for (String groupName : groupNames = value.split(",")) {
                            groupsID.add(MigrationNamesSpaces.GROUP_NAME_PREFIX + groupName.trim());
                        }
                    } else {
                        groupsID.add(MigrationNamesSpaces.GROUP_NAME_PREFIX + value);
                    }
                } else if (metadata.getType().equals((Object)Metadata.ContentType.WORKFLOW_PARAMETER_USER)) {
                    String value = metadata.getValue();
                    if (value.contains(",")) {
                        String[] usernames;
                        for (String username : usernames = value.split(",")) {
                            ConfluenceUser user = this.userAccessor.getUserByName(username.trim());
                            if (!Objects.nonNull(user)) continue;
                            usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                        }
                    } else {
                        ConfluenceUser user = this.userAccessor.getUserByName(value);
                        if (Objects.nonNull(user)) {
                            usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                        }
                    }
                }
            });
        });
        return Map.of(PAGES, pagesID, BLOGS, blogPostID, USERS, usersID, GROUPS, groupsID);
    }

    private boolean checkContentRestrictions(Long contentServerId) {
        boolean isRestricted = false;
        AbstractPage content = this.pageManager.getAbstractPage(contentServerId.longValue());
        if (content != null) {
            if (content.getContentPermissionSet("View") != null || content.getContentPermissionSet("Edit") != null) {
                isRestricted = true;
            } else {
                List inheritedPermissions = this.contentPermissionManager.getInheritedContentPermissionSets((ContentEntityObject)content);
                if (inheritedPermissions != null && !inheritedPermissions.isEmpty()) {
                    isRestricted = true;
                }
            }
        }
        return isRestricted;
    }

    private MigrationEntity populateMigrationEntity(AbstractPage content, String cloudContentId, List<Metadata> contentMetadata) {
        boolean isRestricted;
        MetadataMigrationEntity migrationEntity = new MetadataMigrationEntity();
        migrationEntity.setContentId(cloudContentId);
        migrationEntity.setSpaceKey(content.getSpaceKey());
        migrationEntity.setServerId(content.getIdAsString());
        migrationEntity.setType(content instanceof Page ? PageActivityMigrationEntity.Type.PAGE.toString() : PageActivityMigrationEntity.Type.BLOGPOST.toString());
        migrationEntity.setMetadata(contentMetadata.stream().map(this::mapMetadataToMigrationModel).collect(Collectors.toList()));
        try {
            isRestricted = this.checkContentRestrictions(content.getId());
        }
        catch (Exception e) {
            log.warn("There was an error getting the content restrictions for page id {}: {}", (Object)content.getIdAsString(), (Object)e.getMessage());
            isRestricted = true;
        }
        migrationEntity.setRestricted(isRestricted);
        return migrationEntity;
    }

    private MetadataMigration mapMetadataToMigrationModel(Metadata metadata) {
        MetadataMigration migrationMetadataMigration = new MetadataMigration();
        if (metadata == null) {
            return null;
        }
        migrationMetadataMigration.setType(metadata.getType() != null ? metadata.getType().toString() : null);
        migrationMetadataMigration.setName(metadata.getName());
        migrationMetadataMigration.setValue(metadata.getValue());
        return migrationMetadataMigration;
    }
}

