/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.comalatech.confluence.cloud.migration.entity.domain.metadata.Metadata;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="cloudMetadataGroupIdPopulationUseCase")
public class CloudMetadataGroupIdPopulationUseCase
implements CloudPopulationData<Metadata> {
    private static final Logger log = LoggerFactory.getLogger(CloudMetadataGroupIdPopulationUseCase.class);

    @Override
    public Metadata populateCloudData(Metadata metadata, Map<String, String> groupMappings) {
        if (Metadata.ContentType.WORKFLOW_PARAMETER_GROUP.equals((Object)metadata.getType())) {
            String value = metadata.getValue();
            if (value.contains(",")) {
                String[] groupNames = value.split(",");
                StringBuilder result = new StringBuilder();
                for (int i = 0; i < groupNames.length; ++i) {
                    String groupName = groupNames[i].trim();
                    String processedGroupName = this.processGroupName(groupName, groupMappings);
                    result.append(processedGroupName);
                    if (i >= groupNames.length - 1) continue;
                    result.append(",");
                }
                metadata.setValue(result.toString());
            } else {
                String processedGroupName = this.processGroupName(value, groupMappings);
                metadata.setValue(processedGroupName);
            }
        }
        return metadata;
    }

    private String processGroupName(String groupName, Map<String, String> groupMappings) {
        if (groupMappings.containsKey(MigrationNamesSpaces.GROUP_NAME_PREFIX + groupName)) {
            return groupMappings.get(MigrationNamesSpaces.GROUP_NAME_PREFIX + groupName);
        }
        return groupName;
    }
}

