/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.task;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.model.AppliedPageWorkflow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageWorkflowsConsolidationTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(PageWorkflowsConsolidationTask.class);
    private final ReadWriteTransactionService readWriteTransactionService;
    private final AdhocWorkflowManager adhocWorkflowManager;
    private final PageManager pageManager;
    private final AccessModeService accessModeService;
    private final ComalaI18nBean comalaI18nBean;
    private final LabelManager labelManager;
    private final WorkflowService workflowService;
    private final String spaceKey;
    private final List<Long> contentIds;
    private final String workflowName;
    private final String markup;
    private final String label;

    public PageWorkflowsConsolidationTask(ReadWriteTransactionService readWriteTransactionService, AdhocWorkflowManager adhocWorkflowManager, PageManager pageManager, AccessModeService accessModeService, ComalaI18nBean comalaI18nBean, LabelManager labelManager, WorkflowService workflowService, String spaceKey, List<Long> contentIds, String workflowName, String markup, String label) {
        this.readWriteTransactionService = readWriteTransactionService;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.pageManager = pageManager;
        this.accessModeService = accessModeService;
        this.comalaI18nBean = comalaI18nBean;
        this.labelManager = labelManager;
        this.workflowService = workflowService;
        this.spaceKey = spaceKey;
        this.contentIds = contentIds;
        this.workflowName = workflowName;
        this.markup = markup;
        this.label = label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() {
        AtomicLong pagesProcessed = new AtomicLong(0L);
        ArrayList pagesWithErrors = new ArrayList();
        if (this.contentIds == null || this.contentIds.isEmpty()) {
            throw new RuntimeException("Consolidation Task: No pageIds have been provided");
        }
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.comalaI18nBean.getText("com.comalatech.readonlymode.long.running.task.error"));
        }
        this.adhocWorkflowManager.setConsolidationStatus(this.spaceKey, this.markup, AppliedPageWorkflow.ConsolidationStatus.IN_PROGRESS);
        log.debug((this.label == null ? "Remove page workflows" : "Consolidation") + " task started for workflow " + this.workflowName + " from space " + this.spaceKey);
        this.progress.setCurrentCount(0);
        this.progress.setTotalObjects(this.contentIds.size());
        try {
            this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                Label labelObj = null;
                if (this.label != null) {
                    labelObj = new Label(this.label);
                    this.consolidateSpaceWorkflow(this.contentIds.get(0), labelObj);
                }
                for (Long pageId : this.contentIds) {
                    AbstractPage content = this.pageManager.getAbstractPage(pageId.longValue());
                    if (content != null) {
                        this.progress.setStatus(this.comalaI18nBean.getText(this.getKeyBase() + ".progress.status", new Object[]{String.valueOf(pageId)}));
                        try {
                            if (labelObj != null) {
                                this.addLabel(content, labelObj);
                            }
                            this.removePageWorkflow(content);
                        }
                        catch (Exception e) {
                            pagesWithErrors.add(pageId);
                            throw new RuntimeException("Error processing page: " + pageId, e);
                        }
                    } else {
                        pagesWithErrors.add(pageId);
                        throw new RuntimeException("Page with id " + pageId + " does not exist");
                    }
                    pagesProcessed.addAndGet(1L);
                    this.progress.setPercentage(pagesProcessed.intValue(), this.contentIds.size());
                }
                return null;
            });
        }
        catch (Exception e) {
            this.progress.setStatus(this.comalaI18nBean.getText(this.getKeyBase() + ".error"));
        }
        finally {
            log.debug("Consolidation task set to COMPLETED");
            this.progress.setPercentage(100);
            this.progress.setCompletedSuccessfully(pagesWithErrors.isEmpty());
            if (pagesWithErrors.isEmpty()) {
                this.adhocWorkflowManager.removeConsolidationStatus(this.spaceKey, this.markup);
            } else {
                log.error("Consolidation task status is failed. The following pages had errors: " + pagesWithErrors);
                this.adhocWorkflowManager.setConsolidationStatus(this.spaceKey, this.markup, AppliedPageWorkflow.ConsolidationStatus.FAILED);
            }
        }
    }

    public String getName() {
        return this.comalaI18nBean.getText(this.getKeyBase() + ".task");
    }

    private String getKeyBase() {
        return "awp.space." + (this.label == null ? "removePageWorkflows" : "consolidatePageWorkflows");
    }

    private void addLabel(AbstractPage page, Label label) {
        this.labelManager.addLabel((Labelable)page, label);
    }

    private void removePageWorkflow(AbstractPage page) {
        this.adhocWorkflowManager.removeWorkflow(page);
    }

    private void consolidateSpaceWorkflow(Long contentId, Label label) {
        try {
            AbstractPage content = this.pageManager.getAbstractPage(contentId.longValue());
            if (content == null) {
                throw new WorkflowException("No content found for id: " + contentId);
            }
            Workflow workflow = this.adhocWorkflowManager.getPageWorkflow(content);
            if (workflow == null) {
                throw new WorkflowException("No workflow found for content with id: " + contentId);
            }
            workflow.setLabels(Collections.singletonList(label));
            workflow.setName(this.workflowName + "_(Transformed from Page Workflow)_" + PageWorkflowsConsolidationTask.getRandomNumberString());
            this.workflowService.addSpaceWorkflow(this.spaceKey, workflow.getWorkflowMarkup());
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getRandomNumberString() {
        Random rnd = new Random();
        int number = rnd.nextInt(999999);
        return String.format("%06d", number);
    }
}

