/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.validators;

import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ApprovalsReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.model.StateReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.validators.ParameterValidator;
import java.util.Arrays;
import java.util.List;

public class ColumnsParameterValidator
implements ParameterValidator {
    public static final String TITLE_COLUMN = "title";
    public static final String STATE_COLUMN = "state";
    public static final String APPROVAL_STATUS_COLUMN = "status";
    public static final String APPROVAL_STATUS_COLUMN_ALIAS = "approval status";
    protected static final List<String> commonValidColumns = Arrays.asList("title", "state", "status", "approval status");
    private final String appPluginKey;
    private final List<String> validColumns;

    public ColumnsParameterValidator(String appPluginKey, List<String> validColumns) {
        this.appPluginKey = appPluginKey;
        this.validColumns = validColumns;
    }

    @Override
    public boolean validate(ReportParameter parameter) throws MacroException {
        if ((StateReportParameters.COLUMNS_TO_SHOW.getKey().equals(parameter.getKey()) || ApprovalsReportParameters.COLUMNS_TO_SHOW.getKey().equals(parameter.getKey())) && parameter.getValue() instanceof StringReportParameterValue) {
            String[] columns;
            String paramValue = ((StringReportParameterValue)parameter.getValue()).getValueOrDefault();
            for (String column : columns = paramValue.split(",")) {
                if (this.validColumns.contains(column = column.trim())) continue;
                throw new MacroException(ComalaI18nBean.getComalaI18nBean().getText(this.appPluginKey + ".document-states-report.error.params.columns", new String[]{column}));
            }
        }
        return true;
    }
}

