/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.remote;

import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflow;
import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflowsRepository;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RemoteRepositoryConverter
extends DefaultHandler {
    private StringBuffer value;
    private RemoteWorkflowsRepository repository;
    private RemoteWorkflow workflow;
    private String name;
    private String id;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.value = new StringBuffer();
        if (qName.equals("workflows")) {
            this.repository = new RemoteWorkflowsRepository(this.getDate(attributes.getValue("date")), "true".equalsIgnoreCase(attributes.getValue("learnmore")));
        } else if (qName.equals("workflow")) {
            this.workflow = new RemoteWorkflow(attributes.getValue("id"), attributes.getValue("name"), this.getInt(attributes.getValue("version")), attributes.getValue("chart"), attributes.getValue("url"));
        } else if (qName.equals("category")) {
            this.name = attributes.getValue("name");
            this.id = attributes.getValue("id");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("category")) {
            this.workflow.addCategory(this.id, this.name, this.value.toString().trim());
        } else if (qName.equals("description")) {
            this.workflow.setDescription(this.value.toString().trim());
        } else if (qName.equals("body")) {
            this.workflow.setBody(this.value.toString().trim());
        } else if (qName.equals("workflow")) {
            this.repository.add(this.workflow);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.value.append(ch, start, length);
    }

    private int getInt(String value) throws SAXException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SAXException(e);
        }
    }

    private Date getDate(String value) throws SAXException {
        if (value == null) {
            return null;
        }
        try {
            return RemoteRepositoryConverter.getFormatter().parse(value);
        }
        catch (ParseException e) {
            throw new SAXException(e);
        }
    }

    public static SimpleDateFormat getFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z");
    }

    public RemoteWorkflowsRepository getRepository() {
        this.repository.refreshLoadTime();
        return this.repository;
    }
}

