/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.task;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.CSVBuilder;
import com.comalatech.confluence.util.PackageFileUtil;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflow.usage.download.commands.MetadataWorkflowsCSV;
import com.comalatech.confluence.workflow.usage.download.model.MetadataWorkflowsCSVData;
import com.comalatech.confluence.workflow.usage.model.MetadataWorkflowReportEntry;
import com.comalatech.confluence.workflow.usage.service.WorkflowsUsageReportService;
import com.comalatech.confluence.workflow.usage.task.model.Status;
import com.comalatech.confluence.workflow.usage.task.model.WorkflowsUsageTask;
import com.comalatech.confluence.workflow.usage.util.WorkflowsUsagePackageFile;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataWorkflowReportTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(MetadataWorkflowReportTask.class);
    private final SpaceManager spaceManager;
    private final WorkflowService workflowService;
    private final WorkflowsUsageReportService workflowsUsageReportService;
    private final ComalaI18nBean comalaI18nBean;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final MetadataWorkflowsCSV metadataWorkflowsCSV;
    private final WorkflowsUsageTask workflowsUsageTask;

    public MetadataWorkflowReportTask(SpaceManager spaceManager, WorkflowService workflowService, WorkflowsUsageReportService workflowsUsageReportService, ComalaI18nBean comalaI18nBean, ReadWriteTransactionService readWriteTransactionService, SupportPresenter templateFileLayoutHelper, WorkflowsUsageTask workflowsUsageTask) {
        this.spaceManager = spaceManager;
        this.workflowService = workflowService;
        this.workflowsUsageReportService = workflowsUsageReportService;
        this.comalaI18nBean = comalaI18nBean;
        this.readWriteTransactionService = readWriteTransactionService;
        this.metadataWorkflowsCSV = new MetadataWorkflowsCSV(templateFileLayoutHelper);
        this.workflowsUsageTask = workflowsUsageTask;
    }

    protected void runInternal() {
        Instant startedAt = Instant.now();
        try {
            PackageFileUtil.deleteFolder(WorkflowsUsagePackageFile.getWorkflowsUsageBasePath("metadata"));
            if (!this.isReportTaskReadyToStart()) {
                this.updateProcess(false, Status.FAIL);
                this.finishTaskProcess(startedAt);
                return;
            }
            CSVBuilder csv = new CSVBuilder();
            this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                AtomicLong recordsProcessed = new AtomicLong(0L);
                this.generateHeaders(csv);
                this.progress.setStatus(Status.IN_PROGRESS.getValue());
                List<String> activeSpaceKeys = this.workflowService.getSpacesWithWorkflows(new HashSet<String>(this.spaceManager.getAllSpaceKeys(SpaceStatus.CURRENT)));
                if (!activeSpaceKeys.isEmpty()) {
                    try {
                        List<MetadataWorkflowReportEntry> metadataWorkflowsReport = this.workflowsUsageReportService.getMetadataWorkflowsReport();
                        if (!metadataWorkflowsReport.isEmpty()) {
                            metadataWorkflowsReport.forEach(usageReport -> {
                                this.addUsageReport(csv, (MetadataWorkflowReportEntry)usageReport);
                                csv.newLine();
                            });
                        }
                    }
                    catch (Exception e) {
                        log.error("MetadataWorkflowReportTask error: {}", (Object)e.getMessage(), (Object)e);
                        throw new RuntimeException(e);
                    }
                }
                recordsProcessed.incrementAndGet();
                this.progress.setPercentage(recordsProcessed.intValue() * 90 / activeSpaceKeys.size());
                return null;
            });
            this.metadataWorkflowsCSV.generateSupportFile(MetadataWorkflowsCSVData.builder().csv(csv.get()).build(), PackageFileUtil.generateFolder(WorkflowsUsagePackageFile.getWorkflowsUsageBasePath("metadata")));
            this.updateProcess(true, Status.SUCCESS);
        }
        catch (Exception ex) {
            this.updateProcess(false, Status.FAIL);
            log.error(ex.getMessage(), (Throwable)ex);
        }
        this.finishTaskProcess(startedAt);
    }

    private void updateProcess(boolean completedSuccessfully, Status updateStatus) {
        this.progress.setCompletedSuccessfully(completedSuccessfully);
        this.progress.setStatus(updateStatus.getValue());
        this.workflowsUsageTask.setStatus(updateStatus);
    }

    private void finishTaskProcess(Instant startedAt) {
        this.progress.setPercentage(100);
        this.workflowsUsageTask.setDuration(TimerUtils.getDuration(startedAt));
        this.workflowsUsageReportService.saveMetadataWorkflowsUsageReportTask(this.workflowsUsageTask);
    }

    private void generateHeaders(CSVBuilder csv) {
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.metadata.report.csvexport.space_key.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.metadata.report.csvexport.space_name.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.metadata.report.csvexport.content_id.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.metadata.report.csvexport.content_title.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.metadata.report.csvexport.metadata_name.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.metadata.report.csvexport.metadata_value.header"));
        csv.newLine();
    }

    private void addUsageReport(CSVBuilder csv, MetadataWorkflowReportEntry reportEntry) {
        csv.addCell(reportEntry.getSpaceKey());
        csv.addCell(reportEntry.getSpaceName());
        csv.addCell(reportEntry.getContentId().toString());
        csv.addCell(reportEntry.getContentTitle());
        csv.addCell(reportEntry.getMetadataName().substring("metadata.".length()));
        csv.addCell(Objects.nonNull(reportEntry.getMetadataValue()) ? reportEntry.getMetadataValue() : "");
    }

    private boolean isReportTaskReadyToStart() throws Exception {
        WorkflowsUsageTask storedWorkflowsUsageTask = this.workflowsUsageReportService.getMetadataUsageReportTask();
        LocalDateTime timeLimit = LocalDateTime.now().plusSeconds(180L);
        while (!Status.IN_PROGRESS.equals((Object)storedWorkflowsUsageTask.getStatus()) && TimerUtils.toEpochMilli(LocalDateTime.now()) <= TimerUtils.toEpochMilli(timeLimit)) {
            storedWorkflowsUsageTask = this.workflowsUsageReportService.getMetadataUsageReportTask();
            Thread.sleep(2000L);
        }
        this.workflowsUsageTask.setStartedAt(storedWorkflowsUsageTask.getStartedAt());
        return Status.IN_PROGRESS.equals((Object)storedWorkflowsUsageTask.getStatus());
    }

    public String getName() {
        return "Metadata Workflows report task";
    }
}

