/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.macros.actions.ApprovePageMacro;
import java.util.ArrayList;
import java.util.Map;

public class ApproveChildrenMacro
extends ApprovePageMacro {
    private static final String PARAM_CHILD_APPROVAL_STATE = "state";

    protected String getChildApprovedState() {
        return this.childApprovedState;
    }

    @Override
    protected String getName() {
        return "approve-children";
    }

    @Override
    protected void approve(String approvalName, String comment, AbstractPage page, boolean approved) throws WorkflowException {
        if (!(page instanceof Page)) {
            throw new WorkflowException("{approve-children} can only be used on Pages");
        }
        this.approvalManager.queueApproveChildren(page, approvalName, comment, this.getChildApprovedState());
    }

    @Override
    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        this.childApprovedState = (String)parameters.get(PARAM_CHILD_APPROVAL_STATE);
        if (this.childApprovedState != null && renderContext.getParam((Object)"workflow") != null && !((ArrayList)renderContext.getParam((Object)"workflow")).isEmpty() && !this.isValidChildApprovalState(renderContext, this.childApprovedState)) {
            throw new MacroException("Invalid state name '" + this.childApprovedState + "' for approve-children");
        }
        return super.execute(parameters, body, renderContext);
    }

    private boolean isValidChildApprovalState(RenderContext renderContext, String childApprovedState) {
        return ((ArrayList)renderContext.getParam((Object)"workflow")).stream().anyMatch(elem -> elem instanceof State && childApprovedState.equals(((State)elem).getName()));
    }
}

