/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners.triggers.attachments;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentVersionRemoveEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.manager.EventHistoryManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentChangedEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentCreateEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentRemoveEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentUpdateEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentVersionRemoveEvent;
import com.comalatech.confluence.workflow.listeners.triggers.TriggersListener;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentsTriggersListener
extends TriggersListener {
    private static final Logger log = LoggerFactory.getLogger(AttachmentsTriggersListener.class);
    private final AttachmentManager attachmentManager;
    private final ConfluenceIndexer indexer;

    public AttachmentsTriggersListener(WorkflowAccessor workflowAccessor, WorkflowActionManager workflowActionManager, @ComponentImport EventPublisher eventPublisher, @ComponentImport AttachmentManager attachmentManager, @ComponentImport ConfluenceIndexer indexer, EventHistoryManager eventHistoryManager, @ComponentImport DarkFeatureManager darkFeatureManager) {
        super(workflowAccessor, workflowActionManager, eventHistoryManager, darkFeatureManager, eventPublisher);
        this.attachmentManager = attachmentManager;
        this.indexer = indexer;
    }

    @EventListener
    public void onAttachmentCreateEvent(AttachmentCreateEvent event) {
        this.handleEventTrigger((ContentEvent)event);
    }

    @EventListener
    public void onAttachmentUpdateEvent(AttachmentUpdateEvent event) {
        this.handleEventTrigger((ContentEvent)event);
    }

    @EventListener
    public void onAttachmentVersionRemoveEvent(AttachmentVersionRemoveEvent event) {
        this.handleEventTrigger((ContentEvent)event);
    }

    private void generateWorkflowAttachmentEvent(AttachmentEvent event) {
        Constructor constructor;
        block9: {
            try {
                if (event instanceof AttachmentCreateEvent) {
                    constructor = WorkflowAttachmentCreateEvent.class.getConstructor(Object.class, Attachment.class, AbstractPage.class);
                    break block9;
                }
                if (event instanceof AttachmentUpdateEvent) {
                    constructor = WorkflowAttachmentUpdateEvent.class.getConstructor(Object.class, Attachment.class, AbstractPage.class);
                    break block9;
                }
                if (event instanceof AttachmentVersionRemoveEvent && event.getAttachment().getLatestVersion() != null && this.attachmentManager.getAllVersions((Attachment)event.getAttachment().getLatestVersion()).size() == 1) {
                    constructor = WorkflowAttachmentRemoveEvent.class.getConstructor(Object.class, Attachment.class, AbstractPage.class);
                    break block9;
                }
                if (event instanceof AttachmentVersionRemoveEvent) {
                    constructor = WorkflowAttachmentVersionRemoveEvent.class.getConstructor(Object.class, Attachment.class, AbstractPage.class);
                    break block9;
                }
                log.error("invalid event " + event);
                return;
            }
            catch (NoSuchMethodException e) {
                log.error("could not create constructor", (Throwable)e);
                return;
            }
        }
        for (Attachment attachment : event.getAttachments()) {
            try {
                this.eventPublisher.publish(constructor.newInstance(event.getSource(), attachment, event.getContent()));
            }
            catch (Exception e) {
                log.error("Error instantiating attachment event", (Throwable)e);
                return;
            }
            this.eventPublisher.publish((Object)new WorkflowAttachmentChangedEvent(event.getSource(), attachment, (AbstractPage)event.getContent()));
        }
    }

    @Override
    public void handleEventTrigger(ContentEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            AttachmentEvent attachmentEvent = (AttachmentEvent)event;
            Attachment attachment = attachmentEvent.getAttachment();
            String pageActivityCSVAttachmentRegEx = "^page_activity.*[A-Za-z]{8}\\.csv$";
            if (event instanceof AttachmentCreateEvent && Objects.nonNull(attachment) && attachment.getFileName().matches("^page_activity.*[A-Za-z]{8}\\.csv$")) {
                log.warn("Ignoring trigger attachmentadded or attachmentschanged for page {}. Attach activity feature has generated the attachment {}", (Object)event.getContent().getIdAsString(), (Object)attachment.getFileName());
                return;
            }
            String spaceKey = attachment != null ? attachment.getSpaceKey() : "";
            AbstractPage page = (AbstractPage)event.getContent();
            String spaceActivityZipAttachmentRegEx = "^" + spaceKey + "_activity.*[A-Za-z]{8}.zip$";
            if (event instanceof AttachmentCreateEvent && Objects.nonNull(attachment) && ((Page)page).isHomePage() && attachment.getFileName().matches(spaceActivityZipAttachmentRegEx)) {
                log.warn("Ignoring trigger attachmentadded or attachmentschanged for space home page {}. Attach activity feature has generated the attachment {}", (Object)((Page)event.getContent()).getSpaceKey(), (Object)attachment.getFileName());
                return;
            }
            this.processHistoryEvent(event);
            PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            this.generateWorkflowAttachmentEvent(attachmentEvent);
            this.indexer.reIndex((Searchable)event.getContent());
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }
}

