/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.service;

import com.comalatech.confluence.workflow.esignatures.model.TOTPModel;
import dev.samstevens.totp.code.DefaultCodeGenerator;
import dev.samstevens.totp.code.DefaultCodeVerifier;
import dev.samstevens.totp.code.HashingAlgorithm;
import dev.samstevens.totp.qr.QrData;
import dev.samstevens.totp.secret.DefaultSecretGenerator;
import dev.samstevens.totp.time.SystemTimeProvider;
import javax.validation.constraints.NotNull;

public class TOTPHelper {
    private static final Integer OTP_DIGITS = 6;
    private static final Integer OTP_PERIOD = 30;
    private static final HashingAlgorithm OTP_HASHING = HashingAlgorithm.SHA1;
    private static final Integer OTP_NUM_CHARACTERS = 32;

    public TOTPModel generateSecret(String label, String issuer) {
        TOTPModel totp = new TOTPModel();
        DefaultSecretGenerator secretGenerator = new DefaultSecretGenerator(OTP_NUM_CHARACTERS);
        String secret = secretGenerator.generate();
        totp.setSecret(secret);
        totp.setLabel(label);
        totp.setDigits(OTP_DIGITS);
        totp.setPeriod(OTP_PERIOD);
        totp.setIssuer(issuer);
        totp.setAlgorithm(OTP_HASHING);
        totp.setOtpauth(this.createOtpAuthUri(totp));
        return totp;
    }

    public boolean isValid(@NotNull String secretKey, @NotNull String code) {
        SystemTimeProvider timeProvider = new SystemTimeProvider();
        DefaultCodeGenerator codeGenerator = new DefaultCodeGenerator();
        DefaultCodeVerifier verifier = new DefaultCodeVerifier(codeGenerator, timeProvider);
        return verifier.isValidCode(secretKey, code);
    }

    public String createOtpAuthUri(TOTPModel totpModel) {
        QrData data = new QrData.Builder().label(totpModel.getLabel()).secret(totpModel.getSecret()).issuer(totpModel.getIssuer()).algorithm(totpModel.getAlgorithm()).digits(totpModel.getDigits()).period(totpModel.getPeriod()).build();
        return data.getUri();
    }
}

