/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.dao;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.util.XMLUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.workflow.dao.DefaultApprovalCheckDao;
import com.comalatech.confluence.workflow.dao.sax.ApprovalChecksConverter;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Component
public class SaxApprovalCheckDao
extends DefaultApprovalCheckDao {
    private static final Logger log = LoggerFactory.getLogger(SaxApprovalCheckDao.class);
    private static final String COMMENT_START = "<comment>";
    private static final String COMMENT_END = "</comment>";
    private final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();

    public SaxApprovalCheckDao(@ComponentImport UserAccessor userAccessor, ComalaPropertiesSetManager contentPropertyManager) {
        super(userAccessor, contentPropertyManager);
        this.saxParserFactory.setValidating(false);
        this.saxParserFactory.setNamespaceAware(false);
    }

    @Override
    protected ApprovalCheck deserializeApproval(AbstractPage page, String rawchecks, boolean tryFixingAmpersandError) {
        try {
            ApprovalChecksConverter converter = new ApprovalChecksConverter(this.userAccessor);
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(new InputSource(new StringReader(rawchecks)), (DefaultHandler)converter);
            return converter.getApprovalCheck();
        }
        catch (SAXParseException e) {
            if (tryFixingAmpersandError) {
                try {
                    log.warn("trying to fix xml escaping errors on approvals on " + page);
                    String fixedChecks = SaxApprovalCheckDao.fixChecks(rawchecks);
                    return this.deserializeApproval(page, fixedChecks, false);
                }
                catch (Exception e1) {
                    this.logError(rawchecks, e);
                    return null;
                }
            }
            this.logError(rawchecks, e);
            return null;
        }
        catch (Exception e) {
            this.logError(rawchecks, e);
            return null;
        }
    }

    @Override
    protected ApprovalCheck[] deserializeApprovals(AbstractPage page, String rawchecks, boolean tryFixingAmpersandError) {
        try {
            ApprovalChecksConverter converter = new ApprovalChecksConverter(this.userAccessor);
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(new InputSource(new StringReader(rawchecks)), (DefaultHandler)converter);
            return converter.getApprovalChecks();
        }
        catch (SAXParseException e) {
            if (tryFixingAmpersandError) {
                try {
                    log.warn("trying to fix xml escaping errors on approvals on " + page);
                    String fixedChecks = SaxApprovalCheckDao.fixChecks(rawchecks);
                    return this.deserializeApprovals(page, fixedChecks, false);
                }
                catch (Exception e1) {
                    this.logError(rawchecks, e);
                    return ApprovalCheck.EMPTY_ARRAY;
                }
            }
            this.logError(rawchecks, e);
            return ApprovalCheck.EMPTY_ARRAY;
        }
        catch (Exception e) {
            this.logError(rawchecks, e);
            return ApprovalCheck.EMPTY_ARRAY;
        }
    }

    public static String fixChecks(String rawchecks) throws Exception {
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int ix = rawchecks.indexOf(COMMENT_START);
        while (ix >= 0) {
            sb.append(rawchecks, start, ix).append(COMMENT_START);
            start = ix + COMMENT_START.length();
            int end = rawchecks.indexOf(COMMENT_END, start);
            if (end < 0) {
                throw new Exception("Invalid check format " + rawchecks);
            }
            String comment = rawchecks.substring(start, end);
            comment = XMLUtils.escape((String)comment);
            sb.append(comment).append(COMMENT_END);
            start = end + COMMENT_END.length();
            ix = rawchecks.indexOf(COMMENT_START, start);
        }
        sb.append(rawchecks.substring(start));
        return sb.toString();
    }

    private void logError(String rawchecks, Exception e) {
        if (log.isDebugEnabled()) {
            log.error("Error reading approvals check : " + rawchecks, (Throwable)e);
        } else {
            log.error("Error reading approvals check", (Throwable)e);
        }
    }

    @Override
    protected String serializeApprovals(ApprovalCheck[] approvals) {
        return ApprovalChecksConverter.convertToXml(approvals);
    }

    @Override
    protected String serializeApproval(ApprovalCheck approval) {
        return ApprovalChecksConverter.convertToXml(approval);
    }
}

