/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.extractor;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.dataextractor.queue.AppfireQueueService;
import com.comalatech.confluence.dataextractor.queue.model.QueueTasksContentPropertyItem;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.event.TaskAssignEvent;
import com.comalatech.confluence.tasks.event.TaskCompleteEvent;
import com.comalatech.confluence.tasks.event.TaskCreateEvent;
import com.comalatech.confluence.tasks.event.TaskDeletedEvent;
import com.comalatech.confluence.tasks.event.TasksClearedEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskUpdatedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDueDateCreatedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDueDateDeletedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDueDateUpdatedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskUpdatedEvent;
import com.comalatech.confluence.util.WorkflowsListener;

public class TaskExtractorListener
extends WorkflowsListener {
    private final AppfireQueueService appfireQueueService;

    public TaskExtractorListener(@ComponentImport EventPublisher eventPublisher, AppfireQueueService appfireQueueService) {
        super(eventPublisher);
        this.appfireQueueService = appfireQueueService;
    }

    @EventListener
    public void onTaskCreated(TaskCreateEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTaskUpdated(PageTaskUpdatedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTaskDueDateCreated(PageTaskDueDateCreatedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTaskDueDateUpdated(PageTaskDueDateUpdatedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTaskDueDateDeleted(PageTaskDueDateDeletedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onBlogTaskUpdated(BlogPostTaskUpdatedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTaskAssigned(TaskAssignEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTasksCompleted(TaskCompleteEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTasksCleared(TasksClearedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        this.updateTasks(content);
    }

    @EventListener
    public void onTaskDelete(TaskDeletedEvent event) {
        PageState state = event.getState();
        AbstractPage content = state.getPage();
        this.updateTasks(content);
    }

    private void updateTasks(AbstractPage content) {
        if (content != null) {
            QueueTasksContentPropertyItem queueContentPropertyItem = new QueueTasksContentPropertyItem(content.getId());
            this.appfireQueueService.addTask("content_queue", queueContentPropertyItem);
        }
    }
}

