/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.workflow.rest.model.State;
import com.comalatech.confluence.workflow.rest.model.Trigger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Workflow {
    public String name;
    public String description;
    public List<String> labels;
    public Boolean invertLabels;
    public String pageHeaderTemplate;
    public String pageFooterTemplate;
    public Boolean hideStatus;
    public Boolean hideStatusReadOnly;
    public String adminUsers;
    public List<String> stickyLabels;
    public String key;
    public String blueprintKey;
    public String tip;
    public Boolean updateStatus;
    public List<String> contentTypes;
    public Boolean hideStates;
    public Boolean hideTracker;
    public String tasksMode;
    public List<State> states;
    public List<Trigger> triggers;

    public Workflow() {
    }

    public Workflow(com.comalatech.confluence.workflow.Workflow oldWorkflow) {
        this.name = oldWorkflow.getName();
        this.key = oldWorkflow.getKey();
        this.blueprintKey = oldWorkflow.getBlueprintKey();
        this.tip = oldWorkflow.getTip();
        this.description = oldWorkflow.getDescription();
        this.invertLabels = oldWorkflow.isInvertLabels();
        this.pageHeaderTemplate = oldWorkflow.getPageHeaderTemplate();
        this.pageFooterTemplate = oldWorkflow.getPageFooterTemplate();
        this.adminUsers = oldWorkflow.getAdminUserNames();
        this.updateStatus = oldWorkflow.isUpdateStatus();
        this.hideStatus = oldWorkflow.getHideStatus() == 1;
        this.hideStatusReadOnly = oldWorkflow.getHideStatus() == 2;
        this.hideStates = oldWorkflow.isHideStates();
        this.hideTracker = !oldWorkflow.isDisplayProgressTracker();
        switch (oldWorkflow.getTasksMode()) {
            case STRICT: {
                this.tasksMode = "strict";
                break;
            }
            case LENIENT: {
                this.tasksMode = "lenient";
                break;
            }
            default: {
                this.tasksMode = "default";
            }
        }
        this.contentTypes = new ArrayList<String>();
        if (oldWorkflow.isPageWorkflow()) {
            this.contentTypes.add("page");
        }
        if (oldWorkflow.isBlogPostWorkflow()) {
            this.contentTypes.add("news");
        }
        if (!oldWorkflow.getLabels().isEmpty()) {
            this.labels = new ArrayList<String>();
            this.stickyLabels = new ArrayList<String>();
            for (Label label : oldWorkflow.getLabels()) {
                this.labels.add(label.getName());
                if (!oldWorkflow.isLabelSticky(label)) continue;
                this.stickyLabels.add(label.getName());
            }
        }
        this.states = new ArrayList<State>();
        for (com.comalatech.confluence.states.model.State state : oldWorkflow.getStatesContainer().getStates()) {
            this.states.add(new State(state));
        }
        this.triggers = new ArrayList<Trigger>();
        for (com.comalatech.confluence.workflow.model.Trigger trigger : oldWorkflow.getExplicitTriggers()) {
            this.triggers.add(new Trigger(trigger));
        }
    }
}

