/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.comalatech.confluence.adhocworkflows.rest.model.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@ApiModel(description="Approval information")
public class ContentApproval {
    @ApiModelProperty(value="Name of the approval.", dataType="string", example="Review")
    public String name;
    @ApiModelProperty(value="Approval name translation.", dataType="string", example="Review this page")
    public String nameTranslation;
    @ApiModelProperty(value="Generated unique short name to be used as slug.", dataType="string", example="RW")
    public String shortName;
    @ApiModelProperty(value="The minimum number of users that have to approve the approval. Default = 1.", dataType="integer", example="1")
    public Integer minimumRequiredApprovers;
    @ApiModelProperty(value="The approval must only be approved by 1 user. Default = false.", required=true, dataType="boolean", example="false")
    public boolean isOneApproverOnly;
    @ApiModelProperty(value="Whether the Approval Roles feature is enabled or not.", required=true, dataType="boolean", example="false")
    public boolean isRolesEnabled;
    @ApiModelProperty(value="List of users which can be assigned for this approval.", example="[ \"user1\", \"user2\" ]")
    public List<String> filterUsers;
    @ApiModelProperty(value="List of users excluded from being assigned and approving this approval.", example="[ \"user3\", \"user4\" ]")
    public List<String> filterExcludedUsers;
    @ApiModelProperty(value="List of groups which can be assigned for this approval.", example="[ \"confluence-users\", \"confluence-administrators\" ]")
    public List<String> filterGroups;
    @ApiModelProperty(value="Approvers info.")
    public List<Approver> approvers = new ArrayList<Approver>();
    @ApiModelProperty(value="Custom approve action button label.", dataType="string", example="Accept")
    public String approveLabel;
    @ApiModelProperty(value="Custom reject action button label.", dataType="string", example="Deny")
    public String rejectLabel;

    public ContentApproval() {
    }

    public ContentApproval(String name, String shortName, Integer minimumRequiredApprovers, Boolean isRolesEnabled) {
        this.name = name;
        this.shortName = shortName;
        this.minimumRequiredApprovers = minimumRequiredApprovers;
        this.isRolesEnabled = isRolesEnabled;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @ApiModel(description="Approval user information")
    public static class Approver {
        @ApiModelProperty(value="User information")
        public User user;
        @ApiModelProperty(value="If user approved already", dataType="boolean", required=true, example="true")
        public boolean approved;
        @ApiModelProperty(value="If user rejected already", dataType="boolean", required=true, example="false")
        public boolean rejected;
        @ApiModelProperty(value="Comment assigned to the approval/rejection", dataType="String", example="Approval approved, it is fine")
        public String comment;

        public Approver() {
        }

        public Approver(User user, boolean approved, boolean rejected, String comment) {
            this.user = user;
            this.approved = approved;
            this.rejected = rejected;
            this.comment = comment;
        }
    }
}

