/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.parameter.listener;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.dataextractor.queue.AppfireQueueService;
import com.comalatech.confluence.dataextractor.queue.model.QueueWorkflowsParametersContentPropertyItem;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.workflow.event.WorkflowPageParameterUpdatedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowParametersListener
extends WorkflowsListener {
    private static final Logger log = LoggerFactory.getLogger(WorkflowParametersListener.class);
    private final AppfireQueueService appfireQueueService;

    public WorkflowParametersListener(@ComponentImport EventPublisher eventPublisher, AppfireQueueService appfireQueueService) {
        super(eventPublisher);
        this.appfireQueueService = appfireQueueService;
    }

    @EventListener
    public void onPageParameterEvent(WorkflowPageParameterUpdatedEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        QueueWorkflowsParametersContentPropertyItem queueContentPropertyItem = new QueueWorkflowsParametersContentPropertyItem(content.getId());
        this.appfireQueueService.addTask("content_queue", queueContentPropertyItem);
    }
}

