/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions.metadata;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.ipc.ValueAccessor;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.macros.actions.AbstractActionMacro;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetMetadataMacro
extends AbstractActionMacro {
    private static final Logger log = LoggerFactory.getLogger(SetMetadataMacro.class);
    protected static final String TRIM_PARAM = "trim";
    private ValueAccessor workflowValueAccessor;

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    protected String getName() {
        return "set-metadata";
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        boolean isValidRenderPage;
        String name = MapUtils.getString(parameters, "0");
        boolean trim = MapUtils.getBoolean(parameters, TRIM_PARAM, true);
        List<AbstractPage> pages = this.getPagesFromParams(parameters, renderContext);
        if (!StringUtils.isNotBlank((CharSequence)name)) {
            throw new MacroException("value name not defined");
        }
        ValueStore renderContextValueStore = (ValueStore)renderContext.getParam((Object)"valueStore");
        AbstractPage renderPage = this.getAbstractPage(renderContext);
        boolean bl = isValidRenderPage = renderPage.getSpaceKey() != null && renderPage.getId() != 0L;
        if (this.inExecuteMode(renderContext) || renderContext.getOutputType().equals("display") && isValidRenderPage) {
            String value = trim ? body.trim() : body;
            String string = value = renderContextValueStore != null ? renderContextValueStore.replaceReferences(value) : value;
            if (log.isDebugEnabled()) {
                log.debug("setting metadata name: " + name + "  value: " + value + " on pages: " + pages);
            }
            for (AbstractPage page : pages) {
                ValueStore valueStore = renderContextValueStore != null && renderContextValueStore.getEvent() != null ? this.valueStoreManager.createValueStore(page, renderContextValueStore.getEvent(), renderContextValueStore.getPropertiesMap()) : (renderContextValueStore != null ? this.valueStoreManager.createValueStore(page, renderContextValueStore.getPropertiesMap()) : this.valueStoreManager.createValueStore(page));
                this.workflowValueAccessor.setValue(valueStore.getPage(), name, valueStore.replaceReferences(value));
            }
        }
        return "";
    }

    public void setWorkflowValueAccessor(ValueAccessor workflowValueAccessor) {
        this.workflowValueAccessor = workflowValueAccessor;
    }
}

