/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.cql;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.api.model.search.autocomplete.AutocompleteResult;
import com.atlassian.confluence.api.model.search.autocomplete.AutocompleteResultItem;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.service.WorkflowSearchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/cql")
@Produces(value={"application/json"})
public class CQLResources {
    protected final WorkflowSearchService workflowSearchService;
    protected final LocaleManager localeManager;
    protected final I18NBeanFactory i18NBeanFactory;

    @Inject
    public CQLResources() {
        this.workflowSearchService = PluginContainerManager.getComponent(WorkflowSearchService.class);
        this.localeManager = PluginContainerManager.getComponent(LocaleManager.class);
        this.i18NBeanFactory = PluginContainerManager.getComponent(I18NBeanFactory.class);
    }

    @Autowired
    public CQLResources(WorkflowSearchService workflowSearchService, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory) {
        this.workflowSearchService = workflowSearchService;
        this.localeManager = localeManager;
        this.i18NBeanFactory = i18NBeanFactory;
    }

    @GET
    @com.atlassian.plugins.rest.common.security.UnrestrictedAccess
    @UnrestrictedAccess
    @Path(value="/workflowstate")
    public Response stateSearchAssist(@QueryParam(value="query") String query) {
        if (AuthenticatedUserThreadLocal.get() == null) {
            return Response.ok((Object)AutocompleteResult.builder().suggestedResults(new ArrayList()).build()).build();
        }
        List<String> states = this.workflowSearchService.getSpaceStates(null);
        Collections.sort(states);
        ArrayList<AutocompleteResultItem> resultItems = new ArrayList<AutocompleteResultItem>();
        for (String state : states) {
            if (StringUtils.isNotBlank((CharSequence)query) && !state.contains(query)) continue;
            AutocompleteResultItem item = AutocompleteResultItem.builder().text(state).id(state).build();
            resultItems.add(item);
        }
        AutocompleteResult result = !StringUtils.isNotBlank((CharSequence)query) ? AutocompleteResult.builder().suggestedResults(resultItems).build() : AutocompleteResult.builder().searchResults(resultItems).build();
        return Response.ok((Object)result).build();
    }

    @GET
    @com.atlassian.plugins.rest.common.security.UnrestrictedAccess
    @UnrestrictedAccess
    @Path(value="/hasWorkflow")
    public Response booleanAssist(@QueryParam(value="query") String query) {
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(TimerUtils.getLocale(this.localeManager));
        List<AutocompleteResultItem> resultItems = Collections.singletonList(AutocompleteResultItem.builder().text(i18n.getText("cql.field.has-workflow.yes")).id("true").build());
        AutocompleteResult result = StringUtils.isNotBlank((CharSequence)query) ? AutocompleteResult.builder().searchResults(resultItems).build() : AutocompleteResult.builder().suggestedResults(resultItems).build();
        return Response.ok((Object)result).build();
    }
}

