/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.util.OverridePermissionsUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultOverridePermissionsUtil
implements OverridePermissionsUtil {
    private static final Logger log = LoggerFactory.getLogger(DefaultOverridePermissionsUtil.class);
    private final PermissionManager permissionManager;

    public DefaultOverridePermissionsUtil(@ComponentImport PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public <T> T executeWithExemption(Callable<T> callback) {
        FutureTask<T> futureTask = new FutureTask<T>(callback);
        try {
            this.permissionManager.withExemption(futureTask);
            return futureTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error(e.getMessage());
            return null;
        }
    }
}

