/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.reports;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.readack.ReadAckException;
import com.comalatech.confluence.readack.activeObjects.accessor.ReadAckRecordAccessor;
import com.comalatech.confluence.readack.activeObjects.entity.BaseReadAckRecord;
import com.comalatech.confluence.readack.model.ReadAckPageStatus;
import com.comalatech.confluence.readack.model.ReadAckSearchCriteria;
import com.comalatech.confluence.readack.model.ReadAckSearchFilter;
import com.comalatech.confluence.readack.model.ReadAckStatusType;
import com.comalatech.confluence.readack.reports.ReadAckReportManager;
import com.comalatech.confluence.readack.reports.model.ReadAckReport;
import com.comalatech.confluence.readack.reports.model.ReadAckReportEntry;
import com.comalatech.confluence.readack.service.ReadAckManager;
import com.comalatech.confluence.util.pagination.PaginationSupport;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultReadAckReportManager
implements ReadAckReportManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultReadAckReportManager.class);
    public static final int USER_REPORT_PAGE_SIZE = 20;
    private final ReadAckManager readAckManager;
    private final PageManager pageManager;
    private final ReadAckRecordAccessor readAckRecordAccessor;
    private final PermissionManager permissionManager;
    private final WorkflowAccessor workflowAccessor;

    public DefaultReadAckReportManager(ReadAckManager readAckManager, @ComponentImport PageManager pageManager, ReadAckRecordAccessor readAckRecordAccessor, @ComponentImport PermissionManager permissionManager, WorkflowAccessor workflowAccessor) {
        this.readAckManager = readAckManager;
        this.pageManager = pageManager;
        this.readAckRecordAccessor = readAckRecordAccessor;
        this.permissionManager = permissionManager;
        this.workflowAccessor = workflowAccessor;
    }

    @Override
    public ReadAckReport createUserPendingReadAcksReport(ConfluenceUser user, HttpServletRequest request) {
        PaginationSupport<ReadAckReportEntry> paginationSupport = new PaginationSupport<ReadAckReportEntry>(20);
        paginationSupport.setStartIndex(this.getStartIndexFromRequest(request));
        ReadAckSearchCriteria searchCriteria = new ReadAckSearchCriteria();
        searchCriteria.setStatus(ReadAckStatusType.UserStatusType.PENDING);
        searchCriteria.setUserKey(user.getKey().getStringValue());
        LinkedHashMap<String, String> orderBy = new LinkedHashMap<String, String>();
        orderBy.put("DUE_DATE_TIMESTAMP", "DESC");
        orderBy.put("CREATION_TIMESTAMP", "ASC");
        List<BaseReadAckRecord> userTotalRecords = this.readAckRecordAccessor.search(searchCriteria, new ReadAckSearchFilter(-1, 0, orderBy));
        List<Long> validPageIds = this.getValidPageIds(userTotalRecords, user);
        paginationSupport.setTotal(validPageIds.size());
        if (log.isDebugEnabled()) {
            log.debug("Total number of user pending read assignments: {}", validPageIds);
        }
        ReadAckReport report = new ReadAckReport(paginationSupport);
        report.setUrl(request.getRequestURI() + "?");
        List<ReadAckReportEntry> entries = this.getEntries(paginationSupport, validPageIds);
        report.setEntries(entries);
        return report;
    }

    private List<ReadAckReportEntry> getEntries(PaginationSupport<ReadAckReportEntry> paginationSupport, List<Long> allowedPageIds) {
        ArrayList<ReadAckReportEntry> entries = new ArrayList<ReadAckReportEntry>();
        int fromIndex = paginationSupport.getStartIndex();
        int toIndex = paginationSupport.getStartIndex() + paginationSupport.getPageSize();
        try {
            List<Long> subList = allowedPageIds.subList(fromIndex, Math.min(toIndex, allowedPageIds.size()));
            for (Long pageId : subList) {
                Page page = this.pageManager.getPage(pageId.longValue());
                if (page == null) continue;
                try {
                    ReadAckPageStatus pageStatus = this.readAckManager.getPageStatus((AbstractPage)page, true, true);
                    Date dueDate = pageStatus.getDueDate() != null ? new Date(pageStatus.getDueDate()) : null;
                    entries.add(new ReadAckReportEntry((AbstractPage)page, page.getSpace().getName(), dueDate, pageStatus.getPageStatus().toString()));
                }
                catch (ReadAckException e) {
                    log.error("Can't get ReadAck status for page {}", (Object)page.getTitle(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("An error happened while applying pagination");
        }
        return entries;
    }

    private List<Long> getValidPageIds(List<BaseReadAckRecord> userRecords, ConfluenceUser user) {
        ArrayList<Long> validPageIds = new ArrayList<Long>();
        for (BaseReadAckRecord record : userRecords) {
            Page page = this.pageManager.getPage(record.getPageId().longValue());
            if (!this.isAllowed((AbstractPage)page, user) || !this.isWorkflowWithReadAckApplied((AbstractPage)page)) continue;
            validPageIds.add(record.getPageId());
        }
        return validPageIds;
    }

    private boolean isWorkflowWithReadAckApplied(AbstractPage page) {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        return pageWorkflows != null && !pageWorkflows.getWorkflows().isEmpty() && pageWorkflows.getReadAck() != null;
    }

    private boolean isAllowed(AbstractPage page, ConfluenceUser user) {
        return page != null && this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)page) && page.isCurrent();
    }

    private int getStartIndexFromRequest(HttpServletRequest request) {
        String startIndex = request.getParameter("startIndex");
        if (startIndex == null) {
            return 0;
        }
        try {
            return Integer.parseInt(startIndex);
        }
        catch (NumberFormatException e) {
            log.error("invalid start index");
            return 0;
        }
    }
}

