/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.global;

import com.atlassian.confluence.util.GeneralUtil;
import java.util.Date;
import org.randombits.confluence.filtering.criteria.Criterion;

public class BuildDateCriterion
implements Criterion {
    private Date minValue;
    private Date maxValue;

    public BuildDateCriterion() {
    }

    public BuildDateCriterion(Date minValue, Date maxValue) {
        this();
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public boolean matches(Object object) {
        return this.matchesType(GeneralUtil.getBuildDate());
    }

    private boolean matchesType(Date date) {
        if (this.minValue != null && this.minValue.after(date)) {
            return false;
        }
        return this.maxValue == null || !this.maxValue.before(date);
    }

    public Date getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Date minValue) {
        this.minValue = minValue;
    }

    public Date getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Date maxValue) {
        this.maxValue = maxValue;
    }

    public String toString() {
        return "{build date" + (this.minValue != null ? "; min: " + this.minValue : "") + (this.maxValue != null ? "; max: " + this.maxValue : "") + "}";
    }
}

